/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.hdfs.inode;

import io.hops.hopsworks.persistence.entity.hdfs.inode.InodePK;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsGroups;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import java.io.Serializable;
import java.math.BigInteger;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="hdfs_inodes", catalog="hops")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Inode.findAll", query="SELECT i FROM Inode i"), @NamedQuery(name="Inode.findById", query="SELECT i FROM Inode i WHERE i.id = :id"), @NamedQuery(name="Inode.findByIdInList", query="SELECT i FROM Inode i WHERE i.id IN :idList"), @NamedQuery(name="Inode.findByParentId", query="SELECT i FROM Inode i WHERE i.inodePK.parentId = :parentId"), @NamedQuery(name="Inode.countByParentId", query="SELECT COUNT(DISTINCT i.inodePK.name) FROM Inode i WHERE i.inodePK.parentId = :parentId"), @NamedQuery(name="Inode.findByHdfsUser", query="SELECT i FROM Inode i WHERE i.hdfsUser = :hdfsUser"), @NamedQuery(name="Inode.findByName", query="SELECT i FROM Inode i WHERE i.inodePK.name = :name"), @NamedQuery(name="Inode.findByModificationTime", query="SELECT i FROM Inode i WHERE i.modificationTime = :modificationTime"), @NamedQuery(name="Inode.findByPrimaryKey", query="SELECT i FROM Inode i WHERE i.inodePK = :inodePk"), @NamedQuery(name="Inode.findByAccessTime", query="SELECT i FROM Inode i WHERE i.accessTime = :accessTime"), @NamedQuery(name="Inode.findBySymlink", query="SELECT i FROM Inode i WHERE i.symlink = :symlink"), @NamedQuery(name="Inode.findByQuotaEnabled", query="SELECT i FROM Inode i WHERE i.quotaEnabled = :quotaEnabled"), @NamedQuery(name="Inode.findByUnderConstruction", query="SELECT i FROM Inode i WHERE i.underConstruction = :underConstruction"), @NamedQuery(name="Inode.findRootByName", query="SELECT i FROM Inode i WHERE i.inodePK.parentId = :parentId AND i.inodePK.name = :name AND i.inodePK.partitionId = :partitionId"), @NamedQuery(name="Inode.findByParentAndName", query="SELECT i FROM Inode i WHERE i.inodePK.parentId = :parentId AND i.inodePK.name = :name"), @NamedQuery(name="Inode.findHistoryFileByHdfsUser", query="SELECT i FROM Inode i WHERE i.hdfsUser = :hdfsUser AND i.inodePK.name LIKE '%snappy%'")})
public class Inode
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected InodePK inodePK;
    @Basic(optional=false)
    @NotNull
    @Column(name="id")
    private Long id;
    @Column(name="modification_time")
    private BigInteger modificationTime;
    @Column(name="access_time")
    private BigInteger accessTime;
    @JoinColumn(name="user_id", referencedColumnName="id")
    @OneToOne
    private HdfsUsers hdfsUser;
    @JoinColumn(name="group_id", referencedColumnName="id")
    @OneToOne
    private HdfsGroups hdfsGroup;
    @Column(name="permission")
    private short permission;
    @Size(max=255)
    @Column(name="symlink")
    private @Size(max=255) String symlink;
    @Basic(optional=false)
    @NotNull
    @Column(name="quota_enabled")
    private boolean quotaEnabled;
    @Basic(optional=false)
    @NotNull
    @Column(name="under_construction")
    private boolean underConstruction;
    @Column(name="meta_enabled")
    @NotNull
    private MetaStatus metaStatus;
    @Column(name="is_dir")
    @NotNull
    private boolean dir;
    @Basic(optional=false)
    @NotNull
    @Column(name="children_num")
    private int childrenNum;
    @Basic(optional=false)
    @NotNull
    @Column(name="size")
    private long size;

    public Inode() {
    }

    public Inode(InodePK inodePK) {
        this.inodePK = inodePK;
    }

    public Inode(InodePK inodePK, Long id, boolean quotaEnabled, boolean underConstruction, MetaStatus metaStatus, boolean dir) {
        this.inodePK = inodePK;
        this.id = id;
        this.quotaEnabled = quotaEnabled;
        this.underConstruction = underConstruction;
        this.metaStatus = metaStatus;
        this.dir = dir;
    }

    public Inode(Inode inode) {
        this(new InodePK(inode.getInodePK().getParentId(), inode.getInodePK().getName(), inode.getInodePK().getPartitionId()), inode.getId(), inode.isQuotaEnabled(), inode.isUnderConstruction(), inode.getMetaStatus(), inode.isDir());
    }

    public Inode(long parentId, String name, long partitionId) {
        this.inodePK = new InodePK(parentId, name, partitionId);
    }

    public InodePK getInodePK() {
        return this.inodePK;
    }

    public void setInodePK(InodePK inodePK) {
        this.inodePK = inodePK;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigInteger getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(BigInteger modificationTime) {
        this.modificationTime = modificationTime;
    }

    public BigInteger getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(BigInteger accessTime) {
        this.accessTime = accessTime;
    }

    public short getPermission() {
        return this.permission;
    }

    public void setPermission(short permission) {
        this.permission = permission;
    }

    public String getSymlink() {
        return this.symlink;
    }

    public void setSymlink(String symlink) {
        this.symlink = symlink;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getChildrenNum() {
        return this.childrenNum;
    }

    public void setChildrenNum(int childrenNum) {
        this.childrenNum = childrenNum;
    }

    public HdfsUsers getHdfsUser() {
        return this.hdfsUser;
    }

    public void setHdfsUser(HdfsUsers hdfsUser) {
        this.hdfsUser = hdfsUser;
    }

    public HdfsGroups getHdfsGroup() {
        return this.hdfsGroup;
    }

    public void setHdfsGroup(HdfsGroups hdfsGroup) {
        this.hdfsGroup = hdfsGroup;
    }

    public void setDir(boolean dir) {
        this.dir = dir;
    }

    public boolean isDir() {
        return this.dir;
    }

    public MetaStatus getMetaStatus() {
        return this.metaStatus;
    }

    public void setMetaStatus(MetaStatus metaStatus) {
        this.metaStatus = metaStatus;
    }

    public boolean isQuotaEnabled() {
        return this.quotaEnabled;
    }

    public void setQuotaEnabled(boolean quotaEnabled) {
        this.quotaEnabled = quotaEnabled;
    }

    public boolean isUnderConstruction() {
        return this.underConstruction;
    }

    public void setUnderConstruction(boolean underConstruction) {
        this.underConstruction = underConstruction;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.inodePK != null ? this.inodePK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Inode)) {
            return false;
        }
        Inode other = (Inode)object;
        return (this.inodePK != null || other.inodePK == null) && (this.inodePK == null || this.inodePK.equals(other.inodePK));
    }

    public String toString() {
        return "io.hops.hopsworks.persistence.entity.hdfs.inode.Inode[ inodePK= " + this.inodePK + " ]";
    }

    public static enum MetaStatus {
        DISABLED,
        META_ENABLED,
        MIN_PROV_ENABLED,
        FULL_PROV_ENABLED;

    }
}

