/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.jupyter;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterMode;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterSettingsPK;
import io.hops.hopsworks.persistence.entity.jupyter.config.JupyterConfigurationConverter;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="jupyter_settings", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="JupyterSettings.findAll", query="SELECT j FROM JupyterSettings j"), @NamedQuery(name="JupyterSettings.findByProjectId", query="SELECT j FROM JupyterSettings j WHERE j.jupyterSettingsPK.projectId = :projectId"), @NamedQuery(name="JupyterSettings.findByTeamMember", query="SELECT j FROM JupyterSettings j WHERE j.jupyterSettingsPK.email = :email"), @NamedQuery(name="JupyterSettings.findBySecret", query="SELECT j FROM JupyterSettings j WHERE j.secret = :secret"), @NamedQuery(name="JupyterSettings.findByAdvanced", query="SELECT j FROM JupyterSettings j WHERE j.advanced = :advanced")})
public class JupyterSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected JupyterSettingsPK jupyterSettingsPK;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="secret")
    private @NotNull @Size(min=1, max=255) String secret;
    @Basic(optional=false)
    @Column(name="shutdown_level")
    private int shutdownLevel = 6;
    @Basic(optional=false)
    @Column(name="no_limit")
    private boolean noLimit = false;
    @Basic(optional=false)
    @Column(name="advanced")
    private boolean advanced = false;
    @Basic(optional=false)
    @Column(name="python_kernel")
    private boolean pythonKernel = true;
    @JoinColumn(name="team_member", referencedColumnName="email", insertable=false, updatable=false)
    @ManyToOne(optional=false)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Users users;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="base_dir")
    private @NotNull @Size(min=1, max=255) String baseDir;
    @Column(name="job_config")
    @Convert(converter=JupyterConfigurationConverter.class)
    private JobConfiguration jobConfig;
    @Transient
    private String privateDir = "";
    @Transient
    private JupyterMode mode;

    public JupyterSettings() {
    }

    public JupyterSettings(JupyterSettingsPK jupyterSettingsPK) {
        this.jupyterSettingsPK = jupyterSettingsPK;
    }

    public JupyterSettings(JupyterSettingsPK jupyterSettingsPK, String secret, boolean advanced) {
        this.jupyterSettingsPK = jupyterSettingsPK;
        this.secret = secret;
        this.setAdvanced(advanced);
    }

    public JupyterSettings(int projectId, String email) {
        this.jupyterSettingsPK = new JupyterSettingsPK(projectId, email);
    }

    public JupyterSettingsPK getJupyterSettingsPK() {
        return this.jupyterSettingsPK;
    }

    public void setJupyterSettingsPK(JupyterSettingsPK jupyterSettingsPK) {
        this.jupyterSettingsPK = jupyterSettingsPK;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean getAdvanced() {
        return this.isAdvanced();
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public boolean isNoLimit() {
        return this.noLimit;
    }

    public void setNoLimit(boolean noLimit) {
        this.noLimit = noLimit;
    }

    public Users getUsers() {
        return this.users;
    }

    public void setUsers(Users users) {
        this.users = users;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.jupyterSettingsPK != null ? this.jupyterSettingsPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JupyterSettings)) {
            return false;
        }
        JupyterSettings other = (JupyterSettings)object;
        return (this.jupyterSettingsPK != null || other.jupyterSettingsPK == null) && (this.jupyterSettingsPK == null || this.jupyterSettingsPK.equals(other.jupyterSettingsPK));
    }

    public String toString() {
        return "io.hops.hopsworks.persistence.entity.jupyter.JupyterSettings[ jupyterSettingsPK=" + this.jupyterSettingsPK + " ]";
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getPrivateDir() {
        return this.privateDir;
    }

    public void setPrivateDir(String privateDir) {
        this.privateDir = privateDir;
    }

    public int getShutdownLevel() {
        return this.shutdownLevel;
    }

    public void setShutdownLevel(int shutdownLevel) {
        this.shutdownLevel = shutdownLevel;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public JobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    public void setJobConfig(JobConfiguration jobConfig) {
        this.jobConfig = jobConfig;
    }

    public boolean isPythonKernel() {
        return this.pythonKernel;
    }

    public void setPythonKernel(boolean pythonKernel) {
        this.pythonKernel = pythonKernel;
    }

    public JupyterMode getMode() {
        return this.mode;
    }

    public void setMode(JupyterMode mode) {
        this.mode = mode;
    }
}

