/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.serving;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.hops.hopsworks.persistence.entity.serving.BatchingConfiguration;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class BatchingConfigurationConverter
implements AttributeConverter<BatchingConfiguration, String> {
    private static final Logger LOGGER = Logger.getLogger(BatchingConfigurationConverter.class.getName());
    final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(BatchingConfiguration batchingConfiguration) {
        String jsonConfig;
        try {
            jsonConfig = this.objectMapper.writeValueAsString((Object)batchingConfiguration);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        return jsonConfig;
    }

    public BatchingConfiguration convertToEntityAttribute(String jsonConfig) {
        if (Strings.isNullOrEmpty((String)jsonConfig)) {
            return null;
        }
        try {
            return (BatchingConfiguration)this.objectMapper.readValue(jsonConfig, BatchingConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

