/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.storageconnector.kafka;

import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.kafka.SSLEndpointIdentificationAlgorithm;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.kafka.SecurityProtocol;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="feature_store_kafka_connector", catalog="hopsworks")
@XmlRootElement
public class FeatureStoreKafkaConnector
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @NotNull
    @Column(name="bootstrap_servers")
    private String bootstrapServers;
    @NotNull
    @Column(name="security_protocol")
    private SecurityProtocol securityProtocol;
    @JoinColumns(value={@JoinColumn(name="ssl_secret_uid", referencedColumnName="uid"), @JoinColumn(name="ssl_secret_name", referencedColumnName="secret_name")})
    @ManyToOne(cascade={CascadeType.ALL})
    private Secret sslSecret;
    @Column(name="ssl_endpoint_identification_algorithm")
    private SSLEndpointIdentificationAlgorithm sslEndpointIdentificationAlgorithm;
    @Column(name="options")
    private String options;
    @JoinColumns(value={@JoinColumn(name="truststore_inode_pid", referencedColumnName="parent_id"), @JoinColumn(name="truststore_inode_name", referencedColumnName="name"), @JoinColumn(name="truststore_partition_id", referencedColumnName="partition_id")})
    @ManyToOne
    private Inode truststoreInode;
    @JoinColumns(value={@JoinColumn(name="keystore_inode_pid", referencedColumnName="parent_id"), @JoinColumn(name="keystore_inode_name", referencedColumnName="name"), @JoinColumn(name="keystore_partition_id", referencedColumnName="partition_id")})
    @ManyToOne
    private Inode keystoreInode;

    public static long getSerialVersionUID() {
        return 1L;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public Secret getSslSecret() {
        return this.sslSecret;
    }

    public void setSslSecret(Secret sslSecret) {
        this.sslSecret = sslSecret;
    }

    public SSLEndpointIdentificationAlgorithm getSslEndpointIdentificationAlgorithm() {
        return this.sslEndpointIdentificationAlgorithm;
    }

    public void setSslEndpointIdentificationAlgorithm(SSLEndpointIdentificationAlgorithm sslEndpointIdentificationAlgorithm) {
        this.sslEndpointIdentificationAlgorithm = sslEndpointIdentificationAlgorithm;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public Inode getTruststoreInode() {
        return this.truststoreInode;
    }

    public void setTruststoreInode(Inode truststore_inode) {
        this.truststoreInode = truststore_inode;
    }

    public Inode getKeystoreInode() {
        return this.keystoreInode;
    }

    public void setKeystoreInode(Inode keystore_inode) {
        this.keystoreInode = keystore_inode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureStoreKafkaConnector that = (FeatureStoreKafkaConnector)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.bootstrapServers, that.bootstrapServers) && this.securityProtocol == that.securityProtocol && Objects.equals(this.truststoreInode, that.truststoreInode) && Objects.equals(this.sslSecret, that.sslSecret) && Objects.equals(this.keystoreInode, that.keystoreInode) && this.sslEndpointIdentificationAlgorithm == that.sslEndpointIdentificationAlgorithm && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.bootstrapServers != null ? this.bootstrapServers.hashCode() : 0);
        result = 31 * result + (this.securityProtocol != null ? this.securityProtocol.hashCode() : 0);
        result = 31 * result + (this.truststoreInode != null ? this.truststoreInode.hashCode() : 0);
        result = 31 * result + (this.sslSecret != null ? this.sslSecret.hashCode() : 0);
        result = 31 * result + (this.keystoreInode != null ? this.keystoreInode.hashCode() : 0);
        result = 31 * result + (this.sslEndpointIdentificationAlgorithm != null ? this.sslEndpointIdentificationAlgorithm.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }
}

