/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class FormatUtils {
    static final double K = 1024.0;
    static final double M = 1048576.0;
    static final double G = 1.073741824E9;
    static final double T = 1.099511627776E12;
    static final double m = 60.0;
    static final double h = 3600.0;
    static final double d = 86400.0;

    public static String storage(Long s) {
        DecimalFormat format = new DecimalFormat("#.#");
        Double size = (double)s;
        if (size < 1024.0) {
            return format.format(size) + " B";
        }
        if (size < 1048576.0) {
            return format.format(size / 1024.0) + " KB";
        }
        if (size < 1.073741824E9) {
            return format.format(size / 1048576.0) + " MB";
        }
        if (size < 1.099511627776E12) {
            return format.format(size / 1.073741824E9) + " GB";
        }
        return format.format(size / 1.099511627776E12) + " TB";
    }

    public static String time(Long t) {
        DecimalFormat format = new DecimalFormat("#.#");
        Double time = (double)t.longValue() / 1000.0;
        if (time < 60.0) {
            return format.format(time) + "s";
        }
        if (time < 3600.0) {
            return format.format(time / 60.0) + "m";
        }
        if (time < 86400.0) {
            return format.format(time / 3600.0) + "h";
        }
        return format.format(time / 86400.0) + "d";
    }

    public static String timeInSec(Long t) {
        DecimalFormat format = new DecimalFormat("#.#");
        if (t == null) {
            return "";
        }
        Double time = (double)t;
        if (time < 60.0) {
            return format.format(time) + "s";
        }
        if (time < 3600.0) {
            return format.format(time / 60.0) + "m";
        }
        if (time < 86400.0) {
            return format.format(time / 3600.0) + "h";
        }
        return format.format(time / 86400.0) + "d";
    }

    public static String date(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy h:mm:ss a");
        if (d == null) {
            return "";
        }
        return df.format(d);
    }

    public static String getUserURL(HttpServletRequest req) {
        String domain = req.getRequestURL().toString();
        String cpath = req.getContextPath();
        return domain.substring(0, domain.indexOf(cpath));
    }
}

