/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.python;

import io.hops.hopsworks.persistence.entity.jupyter.config.GitBackend;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="conda_commands", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="CondaCommands.findAll", query="SELECT c FROM CondaCommands c"), @NamedQuery(name="CondaCommands.findById", query="SELECT c FROM CondaCommands c WHERE c.id = :id"), @NamedQuery(name="CondaCommands.findByOp", query="SELECT c FROM CondaCommands c WHERE c.op = :op"), @NamedQuery(name="CondaCommands.findByProj", query="SELECT c FROM CondaCommands c WHERE c.projectId = :projectId"), @NamedQuery(name="CondaCommands.findByProjectAndStatus", query="SELECT c FROM CondaCommands c WHERE c.projectId = :projectId AND c.status = :status"), @NamedQuery(name="CondaCommands.findByProjectAndTypeAndStatus", query="SELECT c FROM CondaCommands c WHERE c.projectId = :projectId AND c.installType = :installType AND c.status = :status"), @NamedQuery(name="CondaCommands.findByProjectAndLibAndStatus", query="SELECT c FROM CondaCommands c WHERE c.projectId = :projectId AND c.lib = :lib AND c.status = :status"), @NamedQuery(name="CondaCommands.findByChannelUrl", query="SELECT c FROM CondaCommands c WHERE c.channelUrl = :channelUrl"), @NamedQuery(name="CondaCommands.findByArg", query="SELECT c FROM CondaCommands c WHERE c.arg = :arg"), @NamedQuery(name="CondaCommands.findByLib", query="SELECT c FROM CondaCommands c WHERE c.lib = :lib"), @NamedQuery(name="CondaCommands.findByVersion", query="SELECT c FROM CondaCommands c WHERE c.version = :version"), @NamedQuery(name="CondaCommands.findByStatus", query="SELECT c FROM CondaCommands c WHERE c.status = :status"), @NamedQuery(name="CondaCommands.findByStatusAndCondaOp", query="SELECT c FROM CondaCommands c WHERE c.status = :status AND c.op = :op"), @NamedQuery(name="CondaCommands.findByStatusListAndCondaOpAndProject", query="SELECT c FROM CondaCommands c WHERE c.status IN :statuses AND c.op = :op AND c.projectId = :project"), @NamedQuery(name="CondaCommands.findByCreated", query="SELECT c FROM CondaCommands c WHERE c.created = :created"), @NamedQuery(name="CondaCommands.deleteAllFailedCommands", query="DELETE FROM CondaCommands c WHERE c.status = :status"), @NamedQuery(name="CondaCommands.deleteAllFailedCommands", query="DELETE FROM CondaCommands c WHERE c.status = :status")})
public class CondaCommands
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="user_id", referencedColumnName="uid")
    @ManyToOne(optional=false)
    private Users userId;
    @Size(max=255)
    @Column(name="channel_url")
    private @Size(max=255) String channelUrl;
    @Size(max=255)
    @Column(name="arg")
    private @Size(max=255) String arg = "";
    @Size(max=255)
    @Column(name="lib")
    private @Size(max=255) String lib = "";
    @Size(max=52)
    @Column(name="version")
    private @Size(max=52) String version = "";
    @Size(max=125)
    @Column(name="git_api_key_name")
    private @Size(max=125) String gitApiKeyName = "";
    @Size(max=45)
    @Column(name="git_backend")
    @Enumerated(value=EnumType.STRING)
    private @Size(max=45) GitBackend gitBackend;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=52)
    @Column(name="op")
    @Enumerated(value=EnumType.STRING)
    private @NotNull @Size(min=1, max=52) CondaOp op;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=52)
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    private @NotNull @Size(min=1, max=52) CondaStatus status;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=52)
    @Column(name="install_type")
    @Enumerated(value=EnumType.STRING)
    private @NotNull @Size(min=1, max=52) CondaInstallType installType;
    @Basic(optional=false)
    @NotNull
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @JoinColumn(name="project_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project projectId;
    @Size(min=1, max=1000)
    @Column(name="environment_file")
    private @Size(min=1, max=1000) String environmentFile;
    @Column(name="install_jupyter")
    private Boolean installJupyter = false;
    @Size(max=10000)
    @Column(name="error_message")
    private @Size(max=10000) String errorMsg = "";

    public CondaCommands() {
    }

    public CondaCommands(Users userId, CondaOp op, CondaStatus status, CondaInstallType installType, Project project, String lib, String version, String channelUrl, Date created, String arg, String environmentFile, Boolean installJupyter) {
        this(userId, op, status, installType, project, lib, version, channelUrl, created, arg, environmentFile, installJupyter, null, null);
    }

    public CondaCommands(Users userId, CondaOp op, CondaStatus status, CondaInstallType installType, Project project, String lib, String version, String channelUrl, Date created, String arg, String environmentFile, Boolean installJupyter, GitBackend gitBackend, String gitApiKeyName) {
        if (op == null || project == null) {
            throw new NullPointerException("Op/project cannot be null");
        }
        this.userId = userId;
        this.op = op;
        this.projectId = project;
        this.status = status;
        this.installType = installType;
        this.created = created;
        this.channelUrl = channelUrl;
        this.lib = lib;
        this.version = version;
        this.arg = arg;
        this.environmentFile = environmentFile;
        this.installJupyter = installJupyter;
        this.gitBackend = gitBackend;
        this.gitApiKeyName = gitApiKeyName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getChannelUrl() {
        return this.channelUrl;
    }

    public void setChannelUrl(String channelUrl) {
        this.channelUrl = channelUrl;
    }

    public String getArg() {
        return this.arg;
    }

    public void setArg(String arg) {
        this.arg = arg;
    }

    public String getLib() {
        return this.lib;
    }

    public void setLib(String lib) {
        this.lib = lib;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Project getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Project projectId) {
        this.projectId = projectId;
    }

    public CondaOp getOp() {
        return this.op;
    }

    public void setOp(CondaOp op) {
        this.op = op;
    }

    public CondaStatus getStatus() {
        return this.status;
    }

    public void setStatus(CondaStatus status) {
        this.status = status;
    }

    public CondaInstallType getInstallType() {
        return this.installType;
    }

    public void setInstallType(CondaInstallType installType) {
        this.installType = installType;
    }

    public String getEnvironmentFile() {
        return this.environmentFile;
    }

    public void setEnvironmentFile(String environmentFile) {
        this.environmentFile = environmentFile;
    }

    public Boolean getInstallJupyter() {
        return this.installJupyter;
    }

    public void setInstallJupyter(Boolean installJupyter) {
        this.installJupyter = installJupyter;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg.substring(Math.max(0, errorMsg.length() - 10000), errorMsg.length());
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CondaCommands)) {
            return false;
        }
        CondaCommands other = (CondaCommands)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        String projectName = this.projectId != null ? this.projectId.getName() : "unknown";
        return "[ id=" + this.id + ", proj=" + projectName + ", op=" + (Object)((Object)this.op) + ", installType=" + (Object)((Object)this.installType) + ", lib=" + this.lib + ", version=" + this.version + ", arg=" + this.arg + ", channel=" + this.channelUrl + "]";
    }

    public Users getUserId() {
        return this.userId;
    }

    public void setUserId(Users userId) {
        this.userId = userId;
    }

    public String getGitApiKeyName() {
        return this.gitApiKeyName;
    }

    public void setGitApiKeyName(String gitApiKeyName) {
        this.gitApiKeyName = gitApiKeyName;
    }

    public GitBackend getGitBackend() {
        return this.gitBackend;
    }

    public void setGitBackend(GitBackend gitBackend) {
        this.gitBackend = gitBackend;
    }
}

