/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached;

import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommitPK;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="feature_group_commit", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="FeatureGroupCommit.findByLatestCommittedOn", query="SELECT fgc FROM FeatureGroupCommit fgc WHERE fgc.committedOn IN (SELECT MAX(fgc.committedOn) FROM FeatureGroupCommit fgc WHERE fgc.committedOn <= :requestedPointInTime AND fgc.featureGroupCommitPK.featureGroupId = :featureGroupId)  AND fgc.featureGroupCommitPK.featureGroupId = :featureGroupId"), @NamedQuery(name="FeatureGroupCommit.findLatestCommit", query="SELECT fgc FROM FeatureGroupCommit fgc WHERE fgc.committedOn IN (SELECT MAX(fgc.committedOn) FROM FeatureGroupCommit fgc WHERE fgc.featureGroupCommitPK.featureGroupId = :featureGroupId) AND fgc.featureGroupCommitPK.featureGroupId = :featureGroupId")})
public class FeatureGroupCommit
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected FeatureGroupCommitPK featureGroupCommitPK;
    @JoinColumns(value={@JoinColumn(name="feature_group_id", referencedColumnName="id", insertable=false, updatable=false)})
    @NotNull
    @Column(name="committed_on", columnDefinition="TIMESTAMP (6)")
    private Timestamp committedOn;
    @Column(name="num_rows_updated")
    private Long numRowsUpdated;
    @Column(name="num_rows_inserted")
    private Long numRowsInserted;
    @Column(name="num_rows_deleted")
    private Long numRowsDeleted;
    @NotNull
    @JoinColumns(value={@JoinColumn(name="inode_pid", referencedColumnName="parent_id"), @JoinColumn(name="inode_name", referencedColumnName="name"), @JoinColumn(name="partition_id", referencedColumnName="partition_id")})
    @ManyToOne(optional=false)
    private Inode inode;

    public FeatureGroupCommit() {
    }

    public FeatureGroupCommit(FeatureGroupCommitPK featureGroupCommitPK) {
        this.featureGroupCommitPK = featureGroupCommitPK;
    }

    public FeatureGroupCommit(Integer featureGroupId, Long commitId) {
        this.featureGroupCommitPK = new FeatureGroupCommitPK(featureGroupId, commitId);
    }

    public FeatureGroupCommitPK getFeatureGroupCommitPK() {
        return this.featureGroupCommitPK;
    }

    public void setFeatureGroupCommitPK(FeatureGroupCommitPK featureGroupCommitPK) {
        this.featureGroupCommitPK = featureGroupCommitPK;
    }

    public Inode getInode() {
        return this.inode;
    }

    public void setInode(Inode inode) {
        this.inode = inode;
    }

    public Long getCommittedOn() {
        return this.committedOn.getTime();
    }

    public void setCommittedOn(Timestamp committedOn) {
        this.committedOn = committedOn;
    }

    public Long getNumRowsUpdated() {
        return this.numRowsUpdated;
    }

    public void setNumRowsUpdated(Long numRowsUpdated) {
        this.numRowsUpdated = numRowsUpdated;
    }

    public Long getNumRowsInserted() {
        return this.numRowsInserted;
    }

    public void setNumRowsInserted(Long numRowsInserted) {
        this.numRowsInserted = numRowsInserted;
    }

    public Long getNumRowsDeleted() {
        return this.numRowsDeleted;
    }

    public void setNumRowsDeleted(Long numRowsDeleted) {
        this.numRowsDeleted = numRowsDeleted;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.featureGroupCommitPK != null ? this.featureGroupCommitPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FeatureGroupCommitPK)) {
            return false;
        }
        FeatureGroupCommit other = (FeatureGroupCommit)object;
        return (this.featureGroupCommitPK != null || other.featureGroupCommitPK == null) && (this.featureGroupCommitPK == null || this.featureGroupCommitPK.equals(other.featureGroupCommitPK));
    }
}

