/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.host;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.hops.hopsworks.persistence.entity.host.Health;
import io.hops.hopsworks.persistence.entity.kagent.HostServices;
import io.hops.hopsworks.persistence.entity.util.FormatUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="hosts", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Hosts.findByHostname", query="SELECT h FROM Hosts h WHERE h.hostname = :hostname"), @NamedQuery(name="Hosts.findByHostIp", query="SELECT h FROM Hosts h WHERE h.hostIp = :hostIp"), @NamedQuery(name="Host.Count", query="SELECT count(h.id) FROM Hosts h"), @NamedQuery(name="Host.CountUnregistered", query="SELECT count(h.id) FROM Hosts h WHERE h.registered = null OR h.registered = false"), @NamedQuery(name="Host.TotalCores", query="SELECT SUM(h.cores) FROM Hosts h"), @NamedQuery(name="Host.TotalGPUs", query="SELECT SUM(h.numGpus) FROM Hosts h"), @NamedQuery(name="Host.TotalMemoryCapacity", query="SELECT SUM(h.memoryCapacity) FROM Hosts h")})
public class Hosts
implements Serializable {
    private static final int HEARTBEAT_INTERVAL = 10;
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Column(name="hostname", nullable=false, length=128)
    private String hostname;
    @Column(name="host_ip", nullable=false, length=128)
    private String hostIp;
    @Column(name="public_ip", length=15)
    private String publicIp;
    @Column(name="private_ip", length=15)
    private String privateIp;
    @Column(name="agent_password")
    private String agentPassword;
    @Column(name="cores")
    private Integer cores;
    @Column(name="last_heartbeat")
    private Long lastHeartbeat;
    @Column(name="memory_capacity")
    private Long memoryCapacity;
    @Column(name="num_gpus")
    private Integer numGpus;
    @Column(name="registered")
    private Boolean registered;
    @OneToMany(mappedBy="host")
    private Collection<HostServices> hostServices;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public void setPrivateIp(String privateIp) {
        this.privateIp = privateIp;
    }

    public String getAgentPassword() {
        return this.agentPassword;
    }

    public void setAgentPassword(String agentPassword) {
        this.agentPassword = agentPassword;
    }

    public Integer getCores() {
        return this.cores;
    }

    public void setCores(Integer cores) {
        this.cores = cores;
    }

    public Long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(Long lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
    }

    public Long getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public void setMemoryCapacity(Long memoryCapacity) {
        this.memoryCapacity = memoryCapacity;
    }

    public Integer getNumGpus() {
        return this.numGpus;
    }

    public void setNumGpus(Integer numGpus) {
        this.numGpus = numGpus;
    }

    public Boolean getRegistered() {
        return this.registered;
    }

    public void setRegistered(Boolean registered) {
        this.registered = registered;
    }

    @JsonIgnore
    @XmlTransient
    public Collection<HostServices> getHostServices() {
        return this.hostServices;
    }

    public void setHostServices(Collection<HostServices> hostServices) {
        this.hostServices = hostServices;
    }

    @JsonIgnore
    public String getPublicOrPrivateIp() {
        if (this.publicIp == null || this.publicIp.isEmpty() || this.publicIp != null && this.privateIp != null) {
            return this.privateIp;
        }
        return this.publicIp;
    }

    @JsonIgnore
    public Health getHealth() {
        int hostTimeout = 21;
        if (this.lastHeartbeat == null) {
            return Health.Bad;
        }
        long deltaInSec = (new Date().getTime() - this.lastHeartbeat) / 1000L;
        if (deltaInSec < (long)hostTimeout) {
            return Health.Good;
        }
        return Health.Bad;
    }

    @JsonIgnore
    public String getLastHeartbeatFormatted() {
        if (this.lastHeartbeat == null) {
            return "";
        }
        return FormatUtils.time(new Date().getTime() - this.lastHeartbeat);
    }

    public String toString() {
        return this.hostIp + "(" + this.hostname + ")";
    }
}

