/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.serving;

import io.hops.hopsworks.persistence.entity.kafka.ProjectTopics;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.serving.BatchingConfiguration;
import io.hops.hopsworks.persistence.entity.serving.BatchingConfigurationConverter;
import io.hops.hopsworks.persistence.entity.serving.ModelFramework;
import io.hops.hopsworks.persistence.entity.serving.ModelServer;
import io.hops.hopsworks.persistence.entity.serving.ServingTool;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="serving", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Serving.findAll", query="SELECT t FROM Serving t"), @NamedQuery(name="Serving.findById", query="SELECT t FROM Serving t WHERE t.id = :id"), @NamedQuery(name="Serving.findByProject", query="SELECT t FROM Serving t WHERE t.project = :project"), @NamedQuery(name="Serving.findByProjectAndModel", query="SELECT t FROM Serving t WHERE t.project = :project AND t.modelName = :modelName"), @NamedQuery(name="Serving.findByProjectAndModelVersion", query="SELECT t FROM Serving t WHERE t.project = :project AND t.modelName = :modelName AND t.modelVersion = :modelVersion"), @NamedQuery(name="Serving.findByProjectAndId", query="SELECT t FROM Serving t WHERE t.project = :project AND t.id = :id"), @NamedQuery(name="Serving.findByCreated", query="SELECT t FROM Serving t WHERE t.created = :created"), @NamedQuery(name="Serving.findLocalhostRunning", query="SELECT t FROM Serving t WHERE t.cid != \"stopped\""), @NamedQuery(name="Serving.expiredLocks", query="SELECT t FROM Serving t WHERE t.lockTimestamp is not NULL AND t.lockTimestamp < :lockts"), @NamedQuery(name="Serving.findByProjectAndName", query="SELECT t FROM Serving t WHERE t.name = :name AND t.project = :project")})
public class Serving
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @JoinColumn(name="creator", referencedColumnName="uid")
    @ManyToOne(optional=false)
    private Users creator;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="name")
    private @NotNull @Size(min=1, max=255) String name;
    @Size(min=1, max=1000)
    @Column(name="description")
    private @Size(min=1, max=1000) String description;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="model_path")
    private @NotNull @Size(min=1, max=255) String modelPath;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="model_name")
    private @NotNull @Size(min=1, max=255) String modelName;
    @Basic(optional=false)
    @NotNull
    @Column(name="model_version")
    private Integer modelVersion;
    @Size(min=1, max=255)
    @Column(name="predictor")
    private @Size(min=1, max=255) String predictor;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="model_framework")
    private ModelFramework modelFramework;
    @Basic(optional=false)
    @NotNull
    @Column(name="optimized")
    private boolean optimized;
    @Column(name="instances")
    private Integer instances;
    @JoinColumn(name="project_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project project;
    @Column(name="lock_ip")
    private String lockIP;
    @Column(name="lock_timestamp")
    private Long lockTimestamp;
    @JoinColumn(name="kafka_topic_id", referencedColumnName="id")
    @ManyToOne
    private ProjectTopics kafkaTopic;
    @Basic(optional=true)
    @Column(name="local_port")
    private Integer localPort;
    @Basic(optional=true)
    @Column(name="cid")
    private String cid;
    @Basic(optional=true)
    @Column(name="local_dir")
    private String localDir;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="model_server")
    private ModelServer modelServer = ModelServer.TENSORFLOW_SERVING;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="serving_tool")
    private ServingTool servingTool = ServingTool.DEFAULT;
    @Basic(optional=true)
    @Column(name="deployed")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deployed;
    @Basic(optional=true)
    @Size(min=1, max=8)
    @Column(name="revision")
    private @Size(min=1, max=8) String revision;
    @Column(name="batching_configuration")
    @NotNull
    @Convert(converter=BatchingConfigurationConverter.class)
    private BatchingConfiguration batchingConfiguration;

    public Serving() {
    }

    public Serving(Integer id, String name, String description, String modelPath, String modelName, Integer modelVersion, ModelFramework modelFramework, String predictor, Integer nInstances, Boolean batchingEnabled, ModelServer modelServer, ServingTool servingTool, BatchingConfiguration batchingConfiguration) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.modelPath = modelPath;
        this.modelName = modelName;
        this.modelVersion = modelVersion;
        this.predictor = predictor;
        this.modelFramework = modelFramework;
        this.instances = nInstances;
        this.modelServer = modelServer;
        this.servingTool = servingTool;
        this.batchingConfiguration = batchingConfiguration;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Users getCreator() {
        return this.creator;
    }

    public void setCreator(Users creator) {
        this.creator = creator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public String getModelVersionPath() {
        return Paths.get(this.getModelPath(), String.valueOf(this.modelVersion)).toString();
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Integer getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(Integer modelVersion) {
        this.modelVersion = modelVersion;
    }

    public String getPredictor() {
        return this.predictor;
    }

    public void setPredictor(String predictor) {
        this.predictor = predictor;
    }

    public ModelFramework getModelFramework() {
        return this.modelFramework;
    }

    public void setModelFramework(ModelFramework modelFramework) {
        this.modelFramework = modelFramework;
    }

    public Integer getInstances() {
        return this.instances;
    }

    public void setInstances(Integer instances) {
        this.instances = instances;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer localPort) {
        this.localPort = localPort;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public String getLocalDir() {
        return this.localDir;
    }

    public void setLocalDir(String localDir) {
        this.localDir = localDir;
    }

    public String getLockIP() {
        return this.lockIP;
    }

    public void setLockIP(String lockIP) {
        this.lockIP = lockIP;
    }

    public Long getLockTimestamp() {
        return this.lockTimestamp;
    }

    public void setLockTimestamp(Long lockTimestamp) {
        this.lockTimestamp = lockTimestamp;
    }

    public ProjectTopics getKafkaTopic() {
        return this.kafkaTopic;
    }

    public void setKafkaTopic(ProjectTopics kafkaTopic) {
        this.kafkaTopic = kafkaTopic;
    }

    public ModelServer getModelServer() {
        return this.modelServer;
    }

    public void setModelServer(ModelServer modelServer) {
        this.modelServer = modelServer;
    }

    public ServingTool getServingTool() {
        return this.servingTool;
    }

    public void setServingTool(ServingTool servingTool) {
        this.servingTool = servingTool;
    }

    public Date getDeployed() {
        return this.deployed;
    }

    public void setDeployed(Date deployed) {
        this.deployed = deployed;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public BatchingConfiguration getBatchingConfiguration() {
        return this.batchingConfiguration;
    }

    public void setBatchingConfiguration(BatchingConfiguration batchingConfiguration) {
        this.batchingConfiguration = batchingConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Serving serving = (Serving)o;
        if (this.optimized != serving.optimized) {
            return false;
        }
        if (this.id != null ? !this.id.equals(serving.id) : serving.id != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(serving.created) : serving.created != null) {
            return false;
        }
        if (this.creator != null ? !this.creator.equals(serving.creator) : serving.creator != null) {
            return false;
        }
        if (!this.name.equals(serving.name)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(serving.description) : serving.description != null) {
            return false;
        }
        if (this.modelPath != null ? !this.modelPath.equals(serving.modelPath) : serving.modelPath != null) {
            return false;
        }
        if (!this.modelVersion.equals(serving.modelVersion)) {
            return false;
        }
        if (this.predictor != null ? !this.predictor.equals(serving.predictor) : serving.predictor != null) {
            return false;
        }
        if (this.modelFramework != null ? !this.modelFramework.equals((Object)serving.modelFramework) : serving.modelFramework != null) {
            return false;
        }
        if (this.instances != null ? !this.instances.equals(serving.instances) : serving.instances != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals(serving.project) : serving.project != null) {
            return false;
        }
        if (this.lockIP != null ? !this.lockIP.equals(serving.lockIP) : serving.lockIP != null) {
            return false;
        }
        if (this.lockTimestamp != null ? !this.lockTimestamp.equals(serving.lockTimestamp) : serving.lockTimestamp != null) {
            return false;
        }
        if (this.kafkaTopic != null ? !this.kafkaTopic.equals(serving.kafkaTopic) : serving.kafkaTopic != null) {
            return false;
        }
        if (this.localPort != null ? !this.localPort.equals(serving.localPort) : serving.localPort != null) {
            return false;
        }
        if (this.cid != null ? !this.cid.equals(serving.cid) : serving.cid != null) {
            return false;
        }
        if (this.modelServer != null ? !this.modelServer.equals((Object)serving.modelServer) : serving.modelServer != null) {
            return false;
        }
        if (this.servingTool != null ? !this.servingTool.equals((Object)serving.servingTool) : serving.servingTool != null) {
            return false;
        }
        if (this.deployed != null ? !this.deployed.equals(serving.deployed) : serving.deployed != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(serving.revision) : serving.revision != null) {
            return false;
        }
        if (this.batchingConfiguration != null ? !this.batchingConfiguration.equals(serving.batchingConfiguration) : serving.batchingConfiguration != null) {
            return false;
        }
        return this.localDir != null ? this.localDir.equals(serving.localDir) : serving.localDir == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.creator != null ? this.creator.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.modelPath.hashCode();
        result = 31 * result + this.modelVersion.hashCode();
        result = 31 * result + (this.predictor != null ? this.predictor.hashCode() : 0);
        result = 31 * result + (this.modelFramework != null ? this.modelFramework.hashCode() : 0);
        result = 31 * result + (this.optimized ? 1 : 0);
        result = 31 * result + (this.instances != null ? this.instances.hashCode() : 0);
        result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
        result = 31 * result + (this.lockIP != null ? this.lockIP.hashCode() : 0);
        result = 31 * result + (this.lockTimestamp != null ? this.lockTimestamp.hashCode() : 0);
        result = 31 * result + (this.kafkaTopic != null ? this.kafkaTopic.hashCode() : 0);
        result = 31 * result + (this.localPort != null ? this.localPort.hashCode() : 0);
        result = 31 * result + (this.cid != null ? this.cid.hashCode() : 0);
        result = 31 * result + (this.localDir != null ? this.localDir.hashCode() : 0);
        result = 31 * result + (this.modelServer != null ? this.modelServer.hashCode() : 0);
        result = 31 * result + (this.servingTool != null ? this.servingTool.hashCode() : 0);
        result = 31 * result + (this.deployed != null ? this.deployed.hashCode() : 0);
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.batchingConfiguration != null ? this.batchingConfiguration.hashCode() : 0);
        return result;
    }
}

