/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.split;

import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.split.SplitType;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="training_dataset_split", catalog="hopsworks", uniqueConstraints={@UniqueConstraint(columnNames={"training_dataset_id", "name"})})
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="TrainingDatasetSplit.findAll", query="SELECT split FROM TrainingDatasetSplit split"), @NamedQuery(name="TrainingDatasetSplit.findById", query="SELECT split FROM TrainingDatasetSplit split WHERE split.id = :id"), @NamedQuery(name="TrainingDatasetSplit.findByTrainingDataset", query="SELECT split FROM TrainingDatasetSplit split WHERE split.trainingDataset = :training_dataset")})
public class TrainingDatasetSplit
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="training_dataset_id", referencedColumnName="id")
    private TrainingDataset trainingDataset;
    @Column(name="name")
    @Basic(optional=false)
    private String name;
    @Column(name="percentage")
    @Basic(optional=true)
    private Float percentage;
    @Column(name="split_type")
    @Enumerated(value=EnumType.STRING)
    @Basic(optional=true)
    private SplitType splitType;
    @Basic
    @Column(name="start_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startTime;
    @Basic
    @Column(name="end_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date endTime;

    public TrainingDatasetSplit() {
    }

    public TrainingDatasetSplit(TrainingDataset trainingDataset, String name, Float percentage) {
        this.trainingDataset = trainingDataset;
        this.splitType = SplitType.RANDOM_SPLIT;
        this.name = name;
        this.percentage = percentage;
    }

    public TrainingDatasetSplit(TrainingDataset trainingDataset, String name, Date startTime, Date endTime) {
        this.trainingDataset = trainingDataset;
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.splitType = SplitType.TIME_SERIES_SPLIT;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public TrainingDataset getTrainingDataset() {
        return this.trainingDataset;
    }

    public void setTrainingDataset(TrainingDataset trainingDataset) {
        this.trainingDataset = trainingDataset;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Float percentage) {
        this.percentage = percentage;
    }

    public SplitType getSplitType() {
        return this.splitType;
    }

    public void setSplitType(SplitType splitType) {
        this.splitType = splitType;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainingDatasetSplit that = (TrainingDatasetSplit)o;
        return this.id.equals(that.id) && this.trainingDataset.getId().equals(that.trainingDataset.getId()) && this.name.equals(that.name) && Objects.equals(this.percentage, that.percentage) && this.splitType == that.splitType && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.trainingDataset.getId(), this.name, this.percentage, this.splitType, this.startTime, this.endTime});
    }
}

