/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.pki;

import io.hops.hopsworks.persistence.entity.pki.CAType;
import io.hops.hopsworks.persistence.entity.pki.PKICertificateId;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@Table(name="pki_certificate", catalog="hopsworks")
@NamedQueries(value={@NamedQuery(name="PKICertificate.findBySerialNumber", query="SELECT c FROM PKICertificate c WHERE c.serialNumber = :serialNumber"), @NamedQuery(name="PKICertificate.findByStatusAndSubject", query="SELECT c FROM PKICertificate c WHERE c.certificateId.status = :status AND c.certificateId.subject = :subject"), @NamedQuery(name="PKICertificate.findSubjectByStatusAndPartialSubject", query="SELECT c.certificateId.subject FROM PKICertificate c WHERE c.certificateId.status = :status AND c.certificateId.subject LIKE CONCAT('%', :subject, '%')")})
public class PKICertificate
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private PKICertificateId certificateId;
    @Basic(optional=false)
    @Enumerated(value=EnumType.ORDINAL)
    private CAType ca;
    @Basic(optional=false)
    @Column(name="serial_number", nullable=false)
    private Long serialNumber;
    @Basic(optional=false)
    @Column(name="not_before", nullable=false)
    private Date notBefore;
    @Basic(optional=false)
    @Column(name="not_after", nullable=false)
    private Date notAfter;
    private byte[] certificate;

    public PKICertificate() {
    }

    public PKICertificate(PKICertificateId certificateId, CAType ca, Long serialNumber, byte[] certificate, Date notBefore, Date notAfter) {
        this.certificateId = certificateId;
        this.ca = ca;
        this.serialNumber = serialNumber;
        this.certificate = certificate;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
    }

    public PKICertificateId getCertificateId() {
        return this.certificateId;
    }

    public void setCertificateId(PKICertificateId certificateId) {
        this.certificateId = certificateId;
    }

    public Long getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(Long serialNumber) {
        this.serialNumber = serialNumber;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = certificate;
    }

    public CAType getCa() {
        return this.ca;
    }

    public void setCa(CAType ca) {
        this.ca = ca;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    public static enum Status {
        VALID,
        REVOKED,
        EXPIRED;

    }
}

