/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.log.operation;

import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.log.operation.OperationOn;
import io.hops.hopsworks.persistence.entity.log.operation.OperationType;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="ops_log", catalog="hopsworks")
public class OperationsLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @Basic(optional=false)
    @NotNull
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Column(name="op_id")
    private Integer opId;
    @Basic(optional=false)
    @NotNull
    @Column(name="op_on")
    private OperationOn opOn;
    @Basic(optional=false)
    @NotNull
    @Column(name="op_type")
    private OperationType opType;
    @Basic(optional=false)
    @NotNull
    @Column(name="project_id")
    private Integer projectId;
    @Basic(optional=false)
    @NotNull
    @Column(name="dataset_id")
    private Long datasetId;
    @Basic(optional=false)
    @NotNull
    @Column(name="inode_id")
    private Long inodeId;

    public OperationsLog() {
    }

    public OperationsLog(Dataset dataset, OperationType opType) {
        this.opId = dataset.getId();
        this.opOn = OperationOn.Dataset;
        this.opType = opType;
        this.projectId = dataset.getProject().getId();
        this.datasetId = dataset.getInodeId();
        this.inodeId = dataset.getInodeId();
    }

    public OperationsLog(Project project, Long projectInodeId, OperationType opType) {
        this.opId = project.getId();
        this.opOn = OperationOn.Project;
        this.opType = opType;
        this.projectId = project.getId();
        this.inodeId = projectInodeId;
        this.datasetId = -1L;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getOpId() {
        return this.opId;
    }

    public void setOpId(Integer opId) {
        this.opId = opId;
    }

    public OperationOn getOpOn() {
        return this.opOn;
    }

    public void setOpOn(OperationOn opOn) {
        this.opOn = opOn;
    }

    public OperationType getOpType() {
        return this.opType;
    }

    public void setOpType(OperationType opType) {
        this.opType = opType;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(Long inodeId) {
        this.inodeId = inodeId;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationsLog other = (OperationsLog)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "OperationsLog{id=" + this.id + ", opId=" + this.opId + ", opOn=" + (Object)((Object)this.opOn) + ", opType=" + (Object)((Object)this.opType) + ", projectId=" + this.projectId + ", datasetId=" + this.datasetId + ", inodeId=" + this.inodeId + '}';
    }
}

