/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.dataset;

import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;

public enum PermissionTransition {
    EDITABLE_TO_EDITABLE_BY_OWNERS("EDITABLE_TO_EDITABLE_BY_OWNERS", DatasetAccessPermission.EDITABLE, DatasetAccessPermission.EDITABLE_BY_OWNERS),
    EDITABLE_TO_READ_ONLY("EDITABLE_TO_READ_ONLY", DatasetAccessPermission.EDITABLE, DatasetAccessPermission.READ_ONLY),
    EDITABLE_TO_EDITABLE("EDITABLE_TO_EDITABLE", DatasetAccessPermission.EDITABLE, DatasetAccessPermission.EDITABLE),
    EDITABLE_BY_OWNERS_TO_EDITABLE("EDITABLE_BY_OWNERS_TO_EDITABLE", DatasetAccessPermission.EDITABLE_BY_OWNERS, DatasetAccessPermission.EDITABLE),
    EDITABLE_BY_OWNERS_TO_READ_ONLY("EDITABLE_BY_OWNERS_TO_READ_ONLY", DatasetAccessPermission.EDITABLE_BY_OWNERS, DatasetAccessPermission.READ_ONLY),
    EDITABLE_BY_OWNERS_TO_EDITABLE_BY_OWNERS("EDITABLE_BY_OWNERS_TO_EDITABLE_BY_OWNERS", DatasetAccessPermission.EDITABLE_BY_OWNERS, DatasetAccessPermission.EDITABLE_BY_OWNERS),
    READ_ONLY_TO_EDITABLE("READ_ONLY_TO_EDITABLE", DatasetAccessPermission.READ_ONLY, DatasetAccessPermission.EDITABLE),
    READ_ONLY_TO_EDITABLE_BY_OWNERS("READ_ONLY_TO_EDITABLE_BY_OWNERS", DatasetAccessPermission.READ_ONLY, DatasetAccessPermission.EDITABLE_BY_OWNERS),
    READ_ONLY_TO_READ_ONLY("READ_ONLY_TO_READ_ONLY", DatasetAccessPermission.READ_ONLY, DatasetAccessPermission.READ_ONLY);

    private final String value;
    private final DatasetAccessPermission from;
    private final DatasetAccessPermission to;

    private PermissionTransition(String value, DatasetAccessPermission from, DatasetAccessPermission to) {
        this.value = value;
        this.from = from;
        this.to = to;
    }

    public static PermissionTransition valueOf(DatasetAccessPermission from, DatasetAccessPermission to) {
        return PermissionTransition.valueOf(from.name() + "_TO_" + to.name());
    }

    public boolean noop() {
        return EDITABLE_TO_EDITABLE.equals((Object)this) || EDITABLE_BY_OWNERS_TO_EDITABLE_BY_OWNERS.equals((Object)this) || READ_ONLY_TO_READ_ONLY.equals((Object)this);
    }

    public DatasetAccessPermission getFrom() {
        return this.from;
    }

    public DatasetAccessPermission getTo() {
        return this.to;
    }
}

