/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.kafka;

import io.hops.hopsworks.persistence.entity.kafka.schemas.Subjects;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="project_topics", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="ProjectTopics.findAll", query="SELECT p FROM ProjectTopics p"), @NamedQuery(name="ProjectTopics.findByTopicName", query="SELECT p FROM ProjectTopics p WHERE p.topicName = :topicName"), @NamedQuery(name="ProjectTopics.findByProject", query="SELECT p FROM ProjectTopics p WHERE p.project = :project"), @NamedQuery(name="ProjectTopics.countByProject", query="SELECT count(p.topicName) FROM ProjectTopics p WHERE p.project = :project"), @NamedQuery(name="ProjectTopics.findByProjectAndTopicName", query="SELECT p FROM ProjectTopics p WHERE p.project = :project AND p.topicName = :topicName"), @NamedQuery(name="ProjectTopics.findBySubjectAndVersion", query="SELECT p FROM ProjectTopics p WHERE p.subjects.subject = :subject AND p.subjects.version = :version AND p.project = :project"), @NamedQuery(name="ProjectTopics.findBySubject", query="SELECT p FROM ProjectTopics p WHERE p.project = :project AND p.subjects.subject = :subject")})
public class ProjectTopics
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @Basic(optional=false)
    @Column(name="id", unique=true)
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="topic_name")
    private @NotNull @Size(min=1, max=255) String topicName;
    @Basic
    @Column(name="num_partitions")
    private Integer numOfPartitions;
    @Basic
    @Column(name="num_replicas")
    private Integer numOfReplicas;
    @JoinColumn(name="project_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project project;
    @JoinColumn(name="subject_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Subjects subjects;

    public ProjectTopics() {
    }

    public ProjectTopics(String topicName, Integer numOfPartitions, Integer numOfReplicas, Project project, Subjects subjects) {
        this.topicName = topicName;
        this.numOfPartitions = numOfPartitions;
        this.numOfReplicas = numOfReplicas;
        this.project = project;
        this.subjects = subjects;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @NotNull
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(@NotNull String topicName) {
        this.topicName = topicName;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Subjects getSubjects() {
        return this.subjects;
    }

    public void setSubjects(Subjects subjects) {
        this.subjects = subjects;
    }

    public Integer getNumOfPartitions() {
        return this.numOfPartitions;
    }

    public void setNumOfPartitions(Integer numOfPartitions) {
        this.numOfPartitions = numOfPartitions;
    }

    public Integer getNumOfReplicas() {
        return this.numOfReplicas;
    }

    public void setNumOfReplicas(Integer numOfReplicas) {
        this.numOfReplicas = numOfReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectTopics topics = (ProjectTopics)o;
        if (this.id != null ? !this.id.equals(topics.id) : topics.id != null) {
            return false;
        }
        if (!this.topicName.equals(topics.topicName)) {
            return false;
        }
        if (this.project != null ? !this.project.equals(topics.project) : topics.project != null) {
            return false;
        }
        return this.subjects != null ? this.subjects.equals(topics.subjects) : topics.subjects == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.topicName != null ? this.topicName.hashCode() : 0);
        result = 31 * result + (this.numOfPartitions != null ? this.numOfPartitions.hashCode() : 0);
        result = 31 * result + (this.numOfReplicas != null ? this.numOfReplicas.hashCode() : 0);
        result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
        result = 31 * result + (this.subjects != null ? this.subjects.hashCode() : 0);
        return result;
    }
}

