/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.dataset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.dataset.DatasetRequest;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.dataset.SharedState;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="dataset", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Dataset.findAll", query="SELECT d FROM Dataset d"), @NamedQuery(name="Dataset.findById", query="SELECT d FROM Dataset d WHERE d.id = :id"), @NamedQuery(name="Dataset.findByProject", query="SELECT d FROM Dataset d WHERE d.project = :project"), @NamedQuery(name="Dataset.findByProjectAndName", query="SELECT d FROM Dataset d WHERE d.project = :project AND d.name = :name"), @NamedQuery(name="Dataset.findBySearchable", query="SELECT d FROM Dataset d WHERE d.searchable = :searchable"), @NamedQuery(name="Dataset.findByPublicDs", query="SELECT d FROM Dataset d WHERE d.publicDs = :publicDs"), @NamedQuery(name="Dataset.findByPublicDsId", query="SELECT d FROM Dataset d WHERE d.publicDsId = :publicDsId"), @NamedQuery(name="Dataset.findByPublicDsIdProject", query="SELECT d FROM Dataset d WHERE d.project = :project AND d.publicDsId = :publicDsId"), @NamedQuery(name="Dataset.findAllPublic", query="SELECT d FROM Dataset d WHERE d.publicDs in (1,2)"), @NamedQuery(name="Dataset.findPublicByState", query="SELECT d FROM Dataset d WHERE d.publicDs = :publicDs"), @NamedQuery(name="Dataset.findByDstype", query="SELECT d FROM Dataset d WHERE d.dsType = :dstype")})
public class Dataset
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @Column(name="inode_name")
    private String name;
    @Size(max=2000)
    @Column(name="description")
    private @Size(max=2000) String description;
    @Basic(optional=false)
    @NotNull
    @Column(name="searchable")
    private boolean searchable;
    @Basic(optional=false)
    @NotNull
    @Column(name="public_ds")
    private int publicDs;
    @Size(max=1000)
    @Column(name="public_ds_id")
    private @Size(max=1000) String publicDsId;
    @Basic(optional=false)
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="dstype")
    private DatasetType dsType = DatasetType.DATASET;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="dataset")
    private Collection<DatasetRequest> datasetRequestCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="dataset")
    private Collection<DatasetSharedWith> datasetSharedWithCollection;
    @JoinColumn(name="feature_store_id", referencedColumnName="id")
    @ManyToOne
    private Featurestore featureStore;
    @JoinColumn(name="projectId", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project project;
    @Basic(optional=false)
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="permission")
    private DatasetAccessPermission permission;

    public Dataset() {
    }

    public Dataset(Integer id) {
        this.id = id;
    }

    public Dataset(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Dataset(Project project, String name, DatasetAccessPermission permission) {
        this.project = project;
        this.name = name;
        this.permission = permission;
    }

    public Dataset(Dataset ds, Project project) {
        this.project = project;
        this.searchable = ds.isSearchable();
        this.description = ds.getDescription();
        this.publicDs = ds.getPublicDs();
        this.dsType = ds.getDsType();
        this.featureStore = ds.getFeatureStore();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public int getPublicDs() {
        return this.publicDs;
    }

    public void setPublicDs(int publicDs) {
        this.publicDs = publicDs;
    }

    public String getPublicDsId() {
        return this.publicDsId;
    }

    public void setPublicDsId(String publicDsId) {
        this.publicDsId = publicDsId;
    }

    public DatasetType getDsType() {
        return this.dsType;
    }

    public void setDsType(DatasetType dsType) {
        this.dsType = dsType;
    }

    public Featurestore getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(Featurestore featureStoreId) {
        this.featureStore = featureStoreId;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<DatasetRequest> getDatasetRequestCollection() {
        return this.datasetRequestCollection;
    }

    public void setDatasetRequestCollection(Collection<DatasetRequest> datasetRequestCollection) {
        this.datasetRequestCollection = datasetRequestCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<DatasetSharedWith> getDatasetSharedWithCollection() {
        return this.datasetSharedWithCollection;
    }

    public void setDatasetSharedWithCollection(Collection<DatasetSharedWith> datasetSharedWithCollection) {
        this.datasetSharedWithCollection = datasetSharedWithCollection;
    }

    public void setPublicDsState(SharedState sharedState) {
        this.publicDs = sharedState.state;
    }

    public boolean isPublicDs() {
        return this.publicDs != 0;
    }

    public boolean isShared(Project project) {
        return !this.project.equals(project);
    }

    public DatasetAccessPermission getPermission() {
        return this.permission;
    }

    public void setPermission(DatasetAccessPermission permission) {
        this.permission = permission;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "Dataset[ id=" + this.id + " ]";
    }
}

