/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.jupyter.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.spark.SparkJobConfiguration;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class JupyterConfigurationConverter
implements AttributeConverter<JobConfiguration, String> {
    private static final Logger LOGGER = Logger.getLogger(JupyterConfigurationConverter.class.getName());
    final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(JobConfiguration config) {
        String jsonConfig;
        try {
            jsonConfig = this.objectMapper.writeValueAsString((Object)config);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        return jsonConfig;
    }

    public JobConfiguration convertToEntityAttribute(String jsonConfig) {
        if (Strings.isNullOrEmpty((String)jsonConfig)) {
            return null;
        }
        try {
            return (JobConfiguration)this.objectMapper.readValue(jsonConfig, SparkJobConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

