/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.jupyter.config;

import com.google.common.base.Strings;
import io.hops.hopsworks.persistence.entity.serving.DockerResourcesConfiguration;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

@Converter
public class DockerResourcesConverter
implements AttributeConverter<DockerResourcesConfiguration, String> {
    private static final Logger LOGGER = Logger.getLogger(DockerResourcesConverter.class.getName());
    private static JAXBContext dockerJAXBContext;

    public String convertToDatabaseColumn(DockerResourcesConfiguration config) {
        if (config == null) {
            config = new DockerResourcesConfiguration();
        }
        try {
            Marshaller marshaller = dockerJAXBContext.createMarshaller();
            marshaller.setProperty("eclipselink.json.include-root", (Object)false);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)config, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public DockerResourcesConfiguration convertToEntityAttribute(String jsonConfig) {
        if (Strings.isNullOrEmpty((String)jsonConfig)) {
            return null;
        }
        try {
            return this.unmarshal(jsonConfig, dockerJAXBContext);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private DockerResourcesConfiguration unmarshal(String jsonConfig, JAXBContext jaxbContext) throws JAXBException {
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StreamSource json = new StreamSource(new StringReader(jsonConfig));
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        return (DockerResourcesConfiguration)unmarshaller.unmarshal((Source)json, DockerResourcesConfiguration.class).getValue();
    }

    static {
        try {
            dockerJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{DockerResourcesConfiguration.class}, null);
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "An error occurred while initializing JAXBContext", e);
        }
    }
}

