/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.commands;

import io.hops.hopsworks.persistence.entity.commands.CommandStatus;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@MappedSuperclass
public abstract class Command {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Long id;
    @JoinColumn(name="project_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project project;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=20)
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    private @NotNull @Size(min=1, max=20) CommandStatus status;
    @Size(max=10000)
    @Column(name="error_message")
    private @Size(max=10000) String errorMsg = "";

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public CommandStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommandStatus status) {
        this.status = status;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Command)) {
            return false;
        }
        Command command = (Command)o;
        return Objects.equals(this.id, command.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        String projectName = this.project != null ? this.project.getName() : "unknown";
        return "command id=" + this.id + ", project=" + projectName + ", status=" + (Object)((Object)this.status);
    }

    public void failWith(String errorMsg) {
        this.setStatus(CommandStatus.FAILED);
        this.setErrorMsg(errorMsg);
    }
}

