/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.commands.search;

import io.hops.hopsworks.persistence.entity.commands.CommandHistory;
import io.hops.hopsworks.persistence.entity.commands.CommandStatus;
import io.hops.hopsworks.persistence.entity.commands.search.SearchFSCommand;
import io.hops.hopsworks.persistence.entity.commands.search.SearchFSCommandOp;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="command_search_fs_history", catalog="hopsworks", schema="")
@XmlRootElement
public class SearchFSCommandHistory
implements CommandHistory,
Serializable {
    public static final String TABLE_NAME = "SearchFSCommandHistory";
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="h_id")
    private Long historyId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="executed", insertable=false)
    private Date executed;
    @Basic(optional=false)
    @Column(name="id")
    private Long id;
    @Column(name="project_id")
    private Integer projectId;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=20)
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    private @NotNull @Size(min=1, max=20) CommandStatus status;
    @Size(max=10000)
    @Column(name="error_message")
    private @Size(max=10000) String errorMsg = "";
    @Column(name="feature_group_id")
    private Integer featureGroupId;
    @Column(name="feature_view_id")
    private Integer featureViewId;
    @Column(name="training_dataset_id")
    private Integer trainingDatasetId;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=20)
    @Column(name="op")
    @Enumerated(value=EnumType.STRING)
    private @NotNull @Size(min=1, max=20) SearchFSCommandOp op;
    @Basic(optional=false)
    @NotNull
    @Column(name="inode_id")
    private Long inodeId;

    public SearchFSCommandHistory() {
    }

    public SearchFSCommandHistory(SearchFSCommand command) {
        this.id = command.getId();
        this.projectId = command.getProject() != null ? command.getProject().getId() : null;
        this.status = command.getStatus();
        this.errorMsg = command.getErrorMsg();
        this.featureGroupId = command.getFeatureGroup() != null ? command.getFeatureGroup().getId() : null;
        this.featureViewId = command.getFeatureView() != null ? command.getFeatureView().getId() : null;
        this.trainingDatasetId = command.getTrainingDataset() != null ? command.getTrainingDataset().getId() : null;
        this.op = command.getOp();
        this.inodeId = command.getInodeId();
    }

    @Override
    public Long getHistoryId() {
        return this.historyId;
    }

    public void setHistoryId(Long historyId) {
        this.historyId = historyId;
    }

    @Override
    public Date getExecuted() {
        return this.executed;
    }

    public void setExecuted(Date executed) {
        this.executed = executed;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public CommandStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommandStatus status) {
        this.status = status;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Integer getFeatureGroupId() {
        return this.featureGroupId;
    }

    public void setFeatureGroupId(Integer featureGroupId) {
        this.featureGroupId = featureGroupId;
    }

    public Integer getFeatureViewId() {
        return this.featureViewId;
    }

    public void setFeatureViewId(Integer featureViewId) {
        this.featureViewId = featureViewId;
    }

    public Integer getTrainingDatasetId() {
        return this.trainingDatasetId;
    }

    public void setTrainingDatasetId(Integer trainingDatasetId) {
        this.trainingDatasetId = trainingDatasetId;
    }

    public SearchFSCommandOp getOp() {
        return this.op;
    }

    public void setOp(SearchFSCommandOp op) {
        this.op = op;
    }

    public Long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(Long inodeId) {
        this.inodeId = inodeId;
    }
}

