/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.hdfs.inode;

import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.dataset.SharedState;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.fs.permission.FsPermission;

@XmlRootElement
public final class InodeView {
    private String name;
    private boolean dir;
    private boolean parent;
    private String path;
    private long size;
    private boolean shared;
    private String owningProjectName;
    private Date modification;
    private Date accessTime;
    private Long id;
    private Long parentId;
    private String description;
    private boolean status = true;
    private boolean underConstruction;
    private String owner;
    private String permission;
    private String email;
    private int publicDs = 0;
    private int sharedWith = 0;
    private boolean searchable = false;
    private String zipState = "NONE";
    private String publicId;
    private DatasetType type;

    public InodeView() {
    }

    public InodeView(Inode i, String path) {
        this.name = i.getInodePK().getName();
        this.dir = i.isDir();
        this.id = i.getId();
        this.parentId = i.getInodePK().getParentId();
        this.size = i.getSize();
        this.underConstruction = i.isUnderConstruction();
        this.parent = false;
        this.path = path;
        this.modification = new Date(i.getModificationTime().longValue());
        this.accessTime = new Date(i.getAccessTime().longValue());
        this.status = true;
        this.owner = i.getHdfsUser().getUsername();
        this.permission = FsPermission.createImmutable((short)i.getPermission()).toString();
    }

    public InodeView(Inode parent, Inode current, Dataset ds, String path) {
        this.name = current.getInodePK().getName();
        this.parentId = parent.getId();
        this.dir = current.isDir();
        this.id = current.getId();
        this.size = current.getSize();
        this.underConstruction = current.isUnderConstruction();
        this.publicId = ds.getPublicDsId();
        this.parent = false;
        this.path = path;
        this.modification = new Date(current.getModificationTime().longValue());
        this.accessTime = new Date(current.getAccessTime().longValue());
        this.shared = false;
        this.owningProjectName = parent.inodePK.getName();
        this.type = ds.getDsType();
        this.description = ds.getDescription();
        this.status = true;
        this.owner = current.getHdfsUser() != null ? current.getHdfsUser().getUsername() : "";
        this.permission = FsPermission.createImmutable((short)current.getPermission()).toString();
        this.publicDs = ds.getPublicDs();
        this.searchable = ds.isSearchable();
    }

    public InodeView(Inode parent, Inode sharedDsInode, DatasetSharedWith ds, String path) {
        this.name = sharedDsInode.getInodePK().getName();
        this.parentId = parent.getId();
        this.dir = sharedDsInode.isDir();
        this.id = sharedDsInode.getId();
        this.size = sharedDsInode.getSize();
        this.underConstruction = sharedDsInode.isUnderConstruction();
        this.publicId = ds.getDataset().getPublicDsId();
        this.parent = false;
        this.path = path;
        this.modification = new Date(sharedDsInode.getModificationTime().longValue());
        this.accessTime = new Date(sharedDsInode.getAccessTime().longValue());
        this.shared = true;
        this.owningProjectName = parent.inodePK.getName();
        this.type = ds.getDataset().getDsType();
        if (this.shared) {
            switch (ds.getDataset().getDsType()) {
                case DATASET: {
                    this.owningProjectName = parent.getInodePK().getName();
                    break;
                }
                case HIVEDB: {
                    this.owningProjectName = this.name.substring(0, this.name.lastIndexOf("."));
                    break;
                }
                case FEATURESTORE: {
                    this.owningProjectName = this.name.substring(0, this.name.lastIndexOf("_"));
                }
            }
            this.name = this.owningProjectName + "::" + this.name;
        }
        this.description = ds.getDataset().getDescription();
        this.status = ds.getAccepted();
        this.owner = sharedDsInode.getHdfsUser() != null ? sharedDsInode.getHdfsUser().getUsername() : "";
        this.permission = FsPermission.createImmutable((short)sharedDsInode.getPermission()).toString();
        this.publicDs = ds.getDataset().getPublicDs();
        this.searchable = ds.getDataset().isSearchable();
    }

    private InodeView(String name, boolean dir, boolean parent, String path) {
        this.name = name;
        this.dir = dir;
        this.parent = parent;
        this.path = path;
        this.modification = null;
    }

    public static InodeView getParentInode(String path) {
        String name = "..";
        boolean dir = true;
        boolean parent = true;
        int lastSlash = path.lastIndexOf("/");
        if (lastSlash == path.length() - 1) {
            lastSlash = path.lastIndexOf("/", lastSlash - 1);
        }
        path = path.substring(0, lastSlash);
        return new InodeView(name, dir, parent, path);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDir(boolean dir) {
        this.dir = dir;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setParent(boolean parent) {
        this.parent = parent;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setModification(Date modification) {
        this.modification = modification;
    }

    public void setAccessTime(Date accessTime) {
        this.accessTime = accessTime;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDir() {
        return this.dir;
    }

    public Long getId() {
        return this.id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public boolean isParent() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public Date getModification() {
        return this.modification;
    }

    public Date getAccessTime() {
        return this.accessTime;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String getOwningProjectName() {
        return this.owningProjectName;
    }

    public void setOwningProjectName(String owningProjectName) {
        this.owningProjectName = owningProjectName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public boolean isUnderConstruction() {
        return this.underConstruction;
    }

    public void setUnderConstruction(boolean underConstruction) {
        this.underConstruction = underConstruction;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public int getPublicDs() {
        return this.publicDs;
    }

    public void setPublicDs(int publicDs) {
        this.publicDs = publicDs;
    }

    public void setPublicDsState(SharedState sharedState) {
        this.publicDs = sharedState.state;
    }

    public boolean isPublicDataset() {
        return this.publicDs != 0;
    }

    public int getSharedWith() {
        return this.sharedWith;
    }

    public void setSharedWith(int sharedWith) {
        this.sharedWith = sharedWith;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public String getZipState() {
        return this.zipState;
    }

    public void setZipState(String zipState) {
        this.zipState = zipState;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public DatasetType getType() {
        return this.type;
    }

    public void setType(DatasetType type) {
        this.type = type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.name);
        hash = 13 * hash + Objects.hashCode(this.path);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InodeView other = (InodeView)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.path, other.path);
    }
}

