/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.jobs.description;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfigurationConverter;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.description.JobAlert;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import io.hops.hopsworks.persistence.entity.jobs.scheduler.JobScheduleV2;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="jobs", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Jobs.findAll", query="SELECT j FROM Jobs j"), @NamedQuery(name="Jobs.findById", query="SELECT j FROM Jobs j WHERE j.id = :id"), @NamedQuery(name="Jobs.findByName", query="SELECT j FROM Jobs j WHERE j.name = :name"), @NamedQuery(name="Jobs.findByCreationTime", query="SELECT j FROM Jobs j WHERE j.creationTime = :creationTime"), @NamedQuery(name="Jobs.findByProject", query="SELECT j FROM Jobs j WHERE j.project = :project"), @NamedQuery(name="Jobs.findByProjectAndId", query="SELECT j FROM Jobs j WHERE j.id = :id AND j.project = :project"), @NamedQuery(name="Jobs.findByProjectAndName", query="SELECT j FROM Jobs j WHERE j.name = :name AND j.project = :project"), @NamedQuery(name="Jobs.updateConfig", query="UPDATE Jobs j SET j.jobConfig = :jobconfig WHERE j.id = :id"), @NamedQuery(name="Jobs.findByProjectAndType", query="SELECT j FROM Jobs j WHERE j.project = :project AND j.type in :typeList ORDER BY j.id ASC")})
public class Jobs
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Size(max=128)
    @Column(name="name")
    private @Size(max=128) String name;
    @Basic(optional=false)
    @NotNull
    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationTime;
    @Column(name="json_config")
    @Convert(converter=JobConfigurationConverter.class)
    private JobConfiguration jobConfig;
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    private JobType type;
    @JoinColumn(name="project_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project project;
    @JoinColumn(name="creator", referencedColumnName="email")
    @ManyToOne(optional=false)
    private Users creator;
    @OneToMany(mappedBy="job")
    private Collection<Execution> executions;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="jobId")
    private Collection<JobAlert> jobAlertCollection;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="job")
    private JobScheduleV2 jobSchedule;

    public Jobs() {
        this.name = "Hopsworks job";
    }

    public Jobs(JobConfiguration config, Project project, Users creator) {
        this(config, project, creator, new Date());
    }

    public Jobs(JobConfiguration config, Project project, Users creator, Date creationTime) {
        this(config, project, creator, null, creationTime);
    }

    public Jobs(JobConfiguration config, Project project, Users creator, String jobname) {
        this(config, project, creator, jobname, new Date());
    }

    protected Jobs(JobConfiguration config, Project project, Users creator, String jobname, Date creationTime) {
        this.name = Strings.isNullOrEmpty((String)jobname) ? "Hopsworks job" : jobname;
        this.creationTime = creationTime;
        this.jobConfig = config;
        this.project = project;
        this.creator = creator;
        this.type = config.getJobType();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public JobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    public void setJobConfig(JobConfiguration jobConfig) {
        this.jobConfig = jobConfig;
    }

    @XmlElement
    public JobType getJobType() {
        return this.type;
    }

    @JsonIgnore
    @XmlTransient
    public Collection<Execution> getExecutions() {
        return this.executions;
    }

    public void setExecutions(Collection<Execution> executions) {
        this.executions = executions;
    }

    public final int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Jobs)) {
            return false;
        }
        Jobs other = (Jobs)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return this.type.toString() + "Job [" + this.name + ", " + this.id + "]";
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Users getCreator() {
        return this.creator;
    }

    public void setCreator(Users creator) {
        this.creator = creator;
    }

    public Collection<JobAlert> getJobAlertCollection() {
        return this.jobAlertCollection;
    }

    public void setJobAlertCollection(Collection<JobAlert> jobAlertCollection) {
        this.jobAlertCollection = jobAlertCollection;
    }

    public JobScheduleV2 getJobSchedule() {
        return this.jobSchedule;
    }
}

