/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.git;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandConfiguration;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class GitCommandConfigurationConverter
implements AttributeConverter<GitCommandConfiguration, String> {
    private static final Logger LOGGER = Logger.getLogger(GitCommandConfiguration.class.getName());
    final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(GitCommandConfiguration commandConfiguration) {
        String jsonConfig;
        try {
            jsonConfig = this.objectMapper.writeValueAsString((Object)commandConfiguration);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        return jsonConfig;
    }

    public GitCommandConfiguration convertToEntityAttribute(String jsonConfig) {
        if (Strings.isNullOrEmpty((String)jsonConfig)) {
            return null;
        }
        try {
            return (GitCommandConfiguration)this.objectMapper.readValue(jsonConfig, GitCommandConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

