/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.dataset;

import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="dataset_shared_with", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="DatasetSharedWith.findAll", query="SELECT d FROM DatasetSharedWith d"), @NamedQuery(name="DatasetSharedWith.findById", query="SELECT d FROM DatasetSharedWith d WHERE d.id = :id"), @NamedQuery(name="DatasetSharedWith.findByDataset", query="SELECT d FROM DatasetSharedWith d WHERE d.dataset = :dataset"), @NamedQuery(name="DatasetSharedWith.findByProject", query="SELECT d FROM DatasetSharedWith d WHERE d.project = :project"), @NamedQuery(name="DatasetSharedWith.findByProjectAndDataset", query="SELECT d FROM DatasetSharedWith d WHERE d.project = :project AND d.dataset = :dataset"), @NamedQuery(name="DatasetSharedWith.findByAccepted", query="SELECT d FROM DatasetSharedWith d WHERE d.accepted = :accepted")})
public class DatasetSharedWith
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @NotNull
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Column(name="accepted")
    private boolean accepted;
    @Basic(optional=false)
    @NotNull
    @Temporal(value=TemporalType.DATE)
    @Column(name="shared_on")
    private Date sharedOn;
    @JoinColumn(name="dataset", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Dataset dataset;
    @JoinColumn(name="project", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project project;
    @Basic(optional=false)
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="permission")
    private DatasetAccessPermission permission;
    @JoinColumn(name="shared_by", referencedColumnName="uid")
    @ManyToOne
    private Users sharedBy;
    @JoinColumn(name="accepted_by", referencedColumnName="uid")
    @ManyToOne
    private Users acceptedBy;

    public DatasetSharedWith() {
    }

    public DatasetSharedWith(Integer id) {
        this.id = id;
    }

    public DatasetSharedWith(Project project, Dataset dataset, DatasetAccessPermission permission, boolean accepted, Users sharedBy) {
        this.project = project;
        this.dataset = dataset;
        this.accepted = accepted;
        this.permission = permission;
        this.sharedOn = new Date();
        this.sharedBy = sharedBy;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean getAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public Date getSharedOn() {
        return this.sharedOn;
    }

    public void setSharedOn(Date sharedOn) {
        this.sharedOn = sharedOn;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public DatasetAccessPermission getPermission() {
        return this.permission;
    }

    public void setPermission(DatasetAccessPermission permission) {
        this.permission = permission;
    }

    public String getDatasetName() {
        return this.dataset.getProject().getName() + "::" + this.dataset.getName();
    }

    public Users getSharedBy() {
        return this.sharedBy;
    }

    public void setSharedBy(Users sharedBy) {
        this.sharedBy = sharedBy;
    }

    public Users getAcceptedBy() {
        return this.acceptedBy;
    }

    public void setAcceptedBy(Users acceptedBy) {
        this.acceptedBy = acceptedBy;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatasetSharedWith)) {
            return false;
        }
        DatasetSharedWith other = (DatasetSharedWith)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith[ id=" + this.id + " ]";
    }
}

