/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.hdfs.command;

import io.hops.hopsworks.persistence.entity.hdfs.command.Command;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="hdfs_command_execution", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="HdfsCommandExecution.findAll", query="SELECT c FROM HdfsCommandExecution c"), @NamedQuery(name="HdfsCommandExecution.findById", query="SELECT c FROM HdfsCommandExecution c WHERE c.id = :id"), @NamedQuery(name="HdfsCommandExecution.findByExecution", query="SELECT c FROM HdfsCommandExecution c WHERE c.execution = :execution"), @NamedQuery(name="HdfsCommandExecution.findBySrcPath", query="SELECT c FROM HdfsCommandExecution c WHERE c.srcPath = :srcPath")})
public class HdfsCommandExecution {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="execution_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Execution execution;
    @Column(name="command", nullable=false, length=45)
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    private Command command;
    @Basic(optional=false)
    @NotNull
    @Column(name="submitted")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date submitted;
    @Column(name="src_path", nullable=false, length=1000)
    private String srcPath;

    public HdfsCommandExecution() {
    }

    public HdfsCommandExecution(Execution execution, Command command, String srcPath) {
        this.execution = execution;
        this.command = command;
        this.submitted = new Date();
        this.srcPath = srcPath;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public void setExecution(Execution execution) {
        this.execution = execution;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Date getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Date submitted) {
        this.submitted = submitted;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HdfsCommandExecution that = (HdfsCommandExecution)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "HdfsCommandExecution{id=" + this.id + ", execution=" + this.execution + ", command=" + (Object)((Object)this.command) + ", submitted=" + this.submitted + ", srcPath=" + this.srcPath + '}';
    }
}

