/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.activity;

import io.hops.hopsworks.persistence.entity.featurestore.activity.ActivityType;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivityMeta;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ExpectationSuite;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationReport;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeaturestoreStatistic;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="feature_store_activity", catalog="hopsworks")
@NamedQueries(value={@NamedQuery(name="FeaturestoreActivity.lastFgExecution", query="SELECT fsa FROM FeaturestoreActivity fsa WHERE fsa.featureGroup = :featureGroup AND fsa.type = :type ORDER BY fsa.eventTime DESC"), @NamedQuery(name="FeaturestoreActivity.lastTdExecution", query="SELECT fsa FROM FeaturestoreActivity fsa WHERE fsa.trainingDataset = :trainingDataset AND fsa.type = :type ORDER BY fsa.eventTime DESC"), @NamedQuery(name="FeaturestoreActivity.findByFgExecution", query="SELECT fsa FROM FeaturestoreActivity fsa WHERE fsa.featureGroup = :featureGroup AND fsa.execution = :execution"), @NamedQuery(name="FeaturestoreActivity.findByTdExecution", query="SELECT fsa FROM FeaturestoreActivity fsa WHERE fsa.trainingDataset = :trainingDataset AND fsa.execution = :execution")})
public class FeaturestoreActivity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int META_MSG_STR_SIZE = 15000;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @Column(name="event_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date eventTime;
    @JoinColumn(name="uid", referencedColumnName="uid")
    @ManyToOne(optional=false)
    private Users user;
    @Basic(optional=false)
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="type")
    private ActivityType type;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="meta_type")
    private FeaturestoreActivityMeta activityMeta;
    @Column(name="meta_msg", length=15000)
    private String activityMetaMsg;
    @JoinColumn(name="execution_id", referencedColumnName="id")
    private Execution execution;
    @JoinColumn(name="statistics_id", referencedColumnName="id")
    private FeaturestoreStatistic statistics;
    @JoinColumns(value={@JoinColumn(name="commit_id", referencedColumnName="commit_id"), @JoinColumn(name="feature_group_id", referencedColumnName="feature_group_id", insertable=false, updatable=false)})
    private FeatureGroupCommit commit;
    @JoinColumn(name="feature_group_id", referencedColumnName="id")
    private Featuregroup featureGroup;
    @JoinColumn(name="training_dataset_id", referencedColumnName="id")
    private TrainingDataset trainingDataset;
    @JoinColumn(name="feature_view_id", referencedColumnName="id")
    private FeatureView featureView;
    @JoinColumn(name="expectation_suite_id", referencedColumnName="id")
    private ExpectationSuite expectationSuite;
    @JoinColumn(name="validation_report_id", referencedColumnName="id")
    private ValidationReport validationReport;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public Users getUser() {
        return this.user;
    }

    public void setUser(Users user) {
        this.user = user;
    }

    public ActivityType getType() {
        return this.type;
    }

    public void setType(ActivityType type) {
        this.type = type;
    }

    public FeaturestoreActivityMeta getActivityMeta() {
        return this.activityMeta;
    }

    public void setActivityMeta(FeaturestoreActivityMeta activityMeta) {
        this.activityMeta = activityMeta;
    }

    public String getActivityMetaMsg() {
        return this.activityMetaMsg;
    }

    public void setActivityMetaMsg(String activityMetaMsg) {
        this.activityMetaMsg = StringUtils.abbreviate((String)activityMetaMsg, (int)15000);
    }

    public Execution getExecution() {
        return this.execution;
    }

    public void setExecution(Execution execution) {
        this.execution = execution;
    }

    public FeaturestoreStatistic getStatistics() {
        return this.statistics;
    }

    public void setStatistics(FeaturestoreStatistic statistics) {
        this.statistics = statistics;
    }

    public FeatureGroupCommit getCommit() {
        return this.commit;
    }

    public void setCommit(FeatureGroupCommit commit) {
        this.commit = commit;
    }

    public Featuregroup getFeatureGroup() {
        return this.featureGroup;
    }

    public void setFeatureGroup(Featuregroup featureGroup) {
        this.featureGroup = featureGroup;
    }

    public TrainingDataset getTrainingDataset() {
        return this.trainingDataset;
    }

    public void setTrainingDataset(TrainingDataset trainingDataset) {
        this.trainingDataset = trainingDataset;
    }

    public FeatureView getFeatureView() {
        return this.featureView;
    }

    public void setFeatureView(FeatureView featureView) {
        this.featureView = featureView;
    }

    public ExpectationSuite getExpectationSuite() {
        return this.expectationSuite;
    }

    public void setExpectationSuite(ExpectationSuite expectationSuite) {
        this.expectationSuite = expectationSuite;
    }

    public ValidationReport getValidationReport() {
        return this.validationReport;
    }

    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeaturestoreActivity that = (FeaturestoreActivity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

