/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.util;

import io.hops.hopsworks.persistence.InvalidQueryException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public abstract class AbstractFacade<T> {
    public static Integer BATCH_SIZE = 100;
    protected final Class<T> entityClass;

    public AbstractFacade(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    protected abstract EntityManager getEntityManager();

    public void save(T entity) {
        this.getEntityManager().persist(entity);
    }

    public T update(T entity) {
        return (T)this.getEntityManager().merge(entity);
    }

    public void remove(T entity) {
        if (entity == null) {
            return;
        }
        this.getEntityManager().remove(this.getEntityManager().merge(entity));
        this.getEntityManager().flush();
    }

    public void removeBatch(List<T> entities) {
        for (T item : entities) {
            this.getEntityManager().remove(this.getEntityManager().merge(item));
        }
        this.getEntityManager().flush();
    }

    public T find(Object id) {
        return (T)this.getEntityManager().find(this.entityClass, id);
    }

    public List<T> findAll() {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(this.entityClass));
        return this.getEntityManager().createQuery(cq).getResultList();
    }

    public List<T> findRange(int[] range) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(this.entityClass));
        TypedQuery q = this.getEntityManager().createQuery(cq);
        q.setMaxResults(range[1] - range[0]);
        q.setFirstResult(range[0]);
        return q.getResultList();
    }

    public long count() {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        Root rt = cq.from(this.entityClass);
        cq.select((Selection)this.getEntityManager().getCriteriaBuilder().count((Expression)rt)).where(new Predicate[0]);
        TypedQuery q = this.getEntityManager().createQuery(cq);
        return (Long)q.getSingleResult();
    }

    public void setOffsetAndLim(Integer offset, Integer limit, Query q) {
        if (offset != null && offset > 0) {
            q.setFirstResult(offset.intValue());
        }
        if (limit != null && limit > 0) {
            q.setMaxResults(limit.intValue());
        }
    }

    public String OrderBy(SortBy sortBy) {
        return sortBy.getSql() + " " + sortBy.getParam().getSql();
    }

    public String buildQuery(String query, Set<? extends FilterBy> filters, Set<? extends SortBy> sorts, String more) {
        return query + this.buildFilterString(filters, more) + this.buildSortString(sorts);
    }

    public String buildSortString(Set<? extends SortBy> sortBy) {
        if (sortBy == null || sortBy.isEmpty()) {
            return "";
        }
        sortBy.remove(null);
        Iterator<? extends SortBy> sort = sortBy.iterator();
        if (!sort.hasNext()) {
            return "";
        }
        StringBuilder c = new StringBuilder(" ORDER BY " + this.OrderBy(sort.next()));
        while (sort.hasNext()) {
            c.append(", ").append(this.OrderBy(sort.next()));
        }
        return c.toString();
    }

    public String buildFilterString(Set<? extends FilterBy> filter, String more) {
        String s;
        String string = s = more == null || more.isEmpty() ? "" : "WHERE " + more;
        if (filter == null || filter.isEmpty()) {
            return s;
        }
        filter.remove(null);
        Iterator<? extends FilterBy> filterBy = filter.iterator();
        if (!filterBy.hasNext()) {
            return s;
        }
        StringBuilder c = new StringBuilder(" WHERE " + filterBy.next().getSql());
        while (filterBy.hasNext()) {
            c.append(" AND ").append(filterBy.next().getSql());
        }
        return c.append(more == null || more.isEmpty() ? "" : " AND " + more).toString();
    }

    public Date getDate(String field, String value) {
        String[] formats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ssX", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:sss", "yyyy-MM-dd"};
        Date date = null;
        for (int i = 0; i < formats.length && date == null; ++i) {
            date = this.getDateByFormat(value, formats[i]);
        }
        if (date == null) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set valid format. Expected:yyyy-MM-dd hh:mm:ss.SSSX but found: " + value);
        }
        return date;
    }

    private Date getDateByFormat(String value, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Integer getIntValue(FilterBy filterBy) {
        return this.getIntValue(filterBy.getField(), filterBy.getParam());
    }

    public Integer getIntValue(String field, String value) {
        Integer val;
        try {
            val = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set an Integer, but found: " + value);
        }
        return val;
    }

    public Long getLongValue(String field, String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set a Long, but found: " + value);
        }
    }

    public List<Integer> getIntValues(FilterBy filterBy) {
        String[] filterStrs = this.splitFilterParams(filterBy);
        ArrayList<Integer> values = new ArrayList<Integer>();
        String field = filterBy.getField();
        for (String filterStr : filterStrs) {
            Integer val = this.getIntValue(field, filterStr);
            values.add(val);
        }
        return values;
    }

    public boolean getBooleanValue(String value) {
        return "1".equals(value) || "true".equalsIgnoreCase(value);
    }

    public <E extends Enum<E>> List<E> getEnumValues(FilterBy filterBy, Class<E> enumType) {
        String[] filterStrs = this.splitFilterParams(filterBy);
        ArrayList<E> enumObjects = new ArrayList<E>();
        String field = filterBy.getField();
        for (String filterStr : filterStrs) {
            E enumObject = this.getEnumValue(field, filterStr, enumType);
            enumObjects.add(enumObject);
        }
        return enumObjects;
    }

    public <E extends Enum<E>> E getEnumValue(String field, String filterStr, Class<E> enumType) {
        E enumObject;
        try {
            enumObject = Enum.valueOf(enumType, filterStr);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set valid " + field + ", but found: " + filterStr, iae);
        }
        return enumObject;
    }

    public String[] splitFilterParams(FilterBy filterBy) {
        return filterBy.getParam().split(",");
    }

    public static class CollectionInfo<A> {
        private Long count;
        private List<A> items;

        public CollectionInfo(Long count, List<A> items) {
            this.count = count;
            this.items = items;
        }

        public Long getCount() {
            return this.count;
        }

        public List<A> getItems() {
            return this.items;
        }

        public void setItems(List<A> items) {
            this.items = items;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }

    public static enum OrderBy {
        ASC("ASC", "ASC"),
        DESC("DESC", "DESC");

        private final String value;
        private final String sql;

        private OrderBy(String value, String sql) {
            this.value = value;
            this.sql = sql;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }

    public static interface FilterBy {
        public String getValue();

        public String getParam();

        public String getSql();

        public String getField();
    }

    public static interface SortBy {
        public String getValue();

        public OrderBy getParam();

        public String getSql();
    }
}

