/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.jobs.scheduler;

import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="job_schedule", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="JobSchedule.getAll", query="SELECT j FROM JobScheduleV2 j"), @NamedQuery(name="JobSchedule.getByJobId", query="SELECT j FROM JobScheduleV2 j WHERE j.job.id = :jobId"), @NamedQuery(name="JobSchedule.getById", query="SELECT j FROM JobScheduleV2 j WHERE j.id = :id"), @NamedQuery(name="JobSchedule.getActiveWithCurrentExecutionTime", query="SELECT j FROM JobScheduleV2 j WHERE j.enabled = true AND j.nextExecutionDateTime <= :currentDateTime")})
public class JobScheduleV2
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @OneToOne(optional=false)
    @JoinColumn(name="job_id", referencedColumnName="id", updatable=false)
    private Jobs job;
    @Column(name="start_date_time")
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startDateTime;
    @Column(name="end_date_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Basic(optional=true)
    private Date endDateTime;
    @Basic(optional=false)
    @NotNull
    @Column(name="enabled")
    private Boolean enabled;
    @Basic(optional=false)
    @Column(name="cron_expression")
    @NotNull
    private String cronExpression;
    @Basic(optional=true)
    @Column(name="next_execution_date_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date nextExecutionDateTime;

    public JobScheduleV2() {
    }

    public JobScheduleV2(Integer id, Jobs job, Instant startDateTime, Instant endDateTime, Boolean enabled, String cronExpression, Instant nextExecutionDateTime) {
        this.id = id;
        this.job = job;
        this.startDateTime = startDateTime != null ? Date.from(startDateTime) : null;
        this.endDateTime = endDateTime != null ? Date.from(endDateTime) : null;
        this.enabled = enabled;
        this.cronExpression = cronExpression;
        this.nextExecutionDateTime = nextExecutionDateTime != null ? Date.from(nextExecutionDateTime) : null;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Jobs getJob() {
        return this.job;
    }

    public void setJob(Jobs job) {
        this.job = job;
    }

    public Instant getStartDateTime() {
        return this.startDateTime != null ? this.startDateTime.toInstant() : null;
    }

    public void setStartDateTime(Instant startDateTime) {
        this.startDateTime = startDateTime != null ? Date.from(startDateTime) : null;
    }

    public Instant getEndDateTime() {
        return this.endDateTime != null ? this.endDateTime.toInstant() : null;
    }

    public void setEndDateTime(Instant endDateTime) {
        this.endDateTime = endDateTime != null ? Date.from(endDateTime) : null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enable) {
        this.enabled = enable;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public Instant getNextExecutionDateTime() {
        return this.nextExecutionDateTime != null ? this.nextExecutionDateTime.toInstant() : null;
    }

    public void setNextExecutionDateTime(Instant nextExecutionDateTime) {
        this.nextExecutionDateTime = nextExecutionDateTime != null ? Date.from(nextExecutionDateTime) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobScheduleV2 that = (JobScheduleV2)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.job, that.job) && Objects.equals(this.startDateTime, that.startDateTime) && Objects.equals(this.endDateTime, that.endDateTime) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.cronExpression, that.cronExpression) && Objects.equals(this.nextExecutionDateTime, that.nextExecutionDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.job, this.startDateTime, this.endDateTime, this.enabled, this.cronExpression, this.nextExecutionDateTime);
    }
}

