/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.git.config;

import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum GitProvider {
    GIT_HUB("GitHub"),
    GIT_LAB("GitLab"),
    BITBUCKET("BitBucket");

    private final String provider;

    private GitProvider(String provider) {
        this.provider = provider;
    }

    public String toString() {
        return this.provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public static GitProvider fromValue(String shortName) throws IllegalArgumentException {
        switch (shortName.toUpperCase()) {
            case "GITHUB": {
                return GIT_HUB;
            }
            case "BITBUCKET": {
                return BITBUCKET;
            }
            case "GITLAB": {
                return GIT_LAB;
            }
        }
        throw new IllegalArgumentException("Git provider [" + shortName + "] not supported.");
    }
}

