/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterProject;
import io.hops.hopsworks.persistence.entity.project.CreationStatus;
import io.hops.hopsworks.persistence.entity.project.PaymentType;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import io.hops.hopsworks.persistence.entity.project.jobs.DefaultJobConfiguration;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServices;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.persistence.entity.python.PythonEnvironment;
import io.hops.hopsworks.persistence.entity.serving.Serving;
import io.hops.hopsworks.persistence.entity.tensorflow.TensorBoard;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.Activity;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="project", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Project.findAll", query="SELECT t FROM Project t"), @NamedQuery(name="Project.findAllOrderByCreated", query="SELECT t FROM Project t ORDER BY t.created"), @NamedQuery(name="Project.findById", query="SELECT t FROM Project t WHERE t.id = :id"), @NamedQuery(name="Project.findByName", query="SELECT t FROM Project t WHERE t.name = :name"), @NamedQuery(name="Project.findByOwner", query="SELECT t FROM Project t WHERE t.owner = :owner"), @NamedQuery(name="Project.findByCreated", query="SELECT t FROM Project t WHERE t.created = :created"), @NamedQuery(name="Project.countProjectByOwner", query="SELECT count(t) FROM Project t WHERE t.owner = :owner"), @NamedQuery(name="Project.findByOwnerAndName", query="SELECT t FROM Project t WHERE t.owner = :owner AND t.name = :name"), @NamedQuery(name="Project.findByNameCaseInsensitive", query="SELECT t FROM Project t where LOWER(t.name) = LOWER(:name)")})
public class Project
implements Serializable {
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project")
    private Collection<ProjectTeam> projectTeamCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project")
    private Collection<Activity> activityCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project")
    private Collection<ProjectServices> projectServicesCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project", fetch=FetchType.LAZY)
    private Collection<Dataset> datasetCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project", fetch=FetchType.LAZY)
    private Collection<DatasetSharedWith> datasetSharedWithCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="projectId")
    private Collection<CondaCommands> condaCommandsCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project")
    private Collection<Serving> servingCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project")
    private Collection<TensorBoard> tensorBoardCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project", orphanRemoval=true)
    private Collection<DefaultJobConfiguration> defaultJobConfigurationCollection;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="project")
    private Collection<Jobs> jobsCollection;
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=88)
    @Column(name="projectname")
    private @NotNull @Size(min=1, max=88) String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="username", referencedColumnName="email")
    private Users owner;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="python_env_id", referencedColumnName="id")
    private PythonEnvironment pythonEnvironment;
    @Basic(optional=false)
    @NotNull
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @NotNull
    @Column(name="payment_type")
    @Enumerated(value=EnumType.STRING)
    private PaymentType paymentType;
    @Size(max=2000)
    @Column(name="description")
    private @Size(max=2000) String description;
    @Basic(optional=false)
    @NotNull
    @Column(name="kafka_max_num_topics")
    private Integer kafkaMaxNumTopics = 10;
    @Basic(optional=false)
    @NotNull
    @Column(name="last_quota_update")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastQuotaUpdate;
    @Size(max=255)
    @Column(name="docker_image")
    private @Size(max=255) String dockerImage;
    @Column(name="topic_name")
    private String topicName;
    @Basic(optional=false)
    @Column(name="online_feature_store_available")
    private Boolean onlineFeatureStoreAvailable;
    @Basic(optional=false)
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="creation_status")
    private CreationStatus creationStatus;
    @JoinTable(name="hopsworks.project_pythondeps", joinColumns={@JoinColumn(name="project_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="dep_id", referencedColumnName="id")})
    @ManyToMany(fetch=FetchType.LAZY)
    private Collection<PythonDep> pythonDepCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project")
    private Collection<JupyterProject> jupyterProjectCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project")
    private Collection<ProjectServiceAlert> projectServiceAlerts;

    public Project() {
    }

    public Project(String name) {
        this.name = name;
    }

    public Project(String name, Users owner, Date timestamp, PaymentType paymentType) {
        this.name = name;
        this.owner = owner;
        this.created = timestamp;
        this.paymentType = paymentType;
        this.lastQuotaUpdate = timestamp;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Users getOwner() {
        return this.owner;
    }

    public void setOwner(Users owner) {
        this.owner = owner;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Project(Integer id) {
        this.id = id;
    }

    public Project(Integer id, String projectname) {
        this.id = id;
        this.name = projectname;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentTypeString() {
        return this.paymentType.name();
    }

    public CreationStatus getCreationStatus() {
        return this.creationStatus;
    }

    public void setCreationStatus(CreationStatus creationStatus) {
        this.creationStatus = creationStatus;
    }

    public Boolean getOnlineFeatureStoreAvailable() {
        return this.onlineFeatureStoreAvailable;
    }

    public void setOnlineFeatureStoreAvailable(Boolean onlineFeatureStoreAvailable) {
        this.onlineFeatureStoreAvailable = onlineFeatureStoreAvailable;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Project)) {
            return false;
        }
        Project other = (Project)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    @XmlTransient
    @JsonIgnore
    public Collection<ProjectTeam> getProjectTeamCollection() {
        return this.projectTeamCollection;
    }

    public void setProjectTeamCollection(Collection<ProjectTeam> projectTeamCollection) {
        this.projectTeamCollection = projectTeamCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<Activity> getActivityCollection() {
        return this.activityCollection;
    }

    public void setActivityCollection(Collection<Activity> activityCollection) {
        this.activityCollection = activityCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<ProjectServices> getProjectServicesCollection() {
        return this.projectServicesCollection;
    }

    public void setProjectServicesCollection(Collection<ProjectServices> projectServicesCollection) {
        this.projectServicesCollection = projectServicesCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<Dataset> getDatasetCollection() {
        return this.datasetCollection;
    }

    public void setDatasetCollection(Collection<Dataset> datasetCollection) {
        this.datasetCollection = datasetCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<DatasetSharedWith> getDatasetSharedWithCollection() {
        return this.datasetSharedWithCollection;
    }

    public void setDatasetSharedWithCollection(Collection<DatasetSharedWith> datasetSharedWithCollection) {
        this.datasetSharedWithCollection = datasetSharedWithCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<PythonDep> getPythonDepCollection() {
        return this.pythonDepCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Map<String, PythonDep> getPythonDepMap() {
        HashMap<String, PythonDep> map = new HashMap<String, PythonDep>();
        for (PythonDep dep : this.pythonDepCollection) {
            map.put(dep.getDependency(), dep);
        }
        return map;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<CondaCommands> getCondaCommandsCollection() {
        return this.condaCommandsCollection;
    }

    public void setCondaCommandsCollection(Collection<CondaCommands> condaCommandsCollection) {
        this.condaCommandsCollection = condaCommandsCollection;
    }

    public void setPythonDepCollection(Collection<PythonDep> pythonDepCollection) {
        this.pythonDepCollection = pythonDepCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<JupyterProject> getJupyterProjectCollection() {
        return this.jupyterProjectCollection;
    }

    public void setJupyterProjectCollection(Collection<JupyterProject> jupyterProjectCollection) {
        this.jupyterProjectCollection = jupyterProjectCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<Serving> getServingCollection() {
        return this.servingCollection;
    }

    public void setServingCollection(Collection<Serving> servingCollection) {
        this.servingCollection = servingCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<TensorBoard> getTensorBoardCollection() {
        return this.tensorBoardCollection;
    }

    public void setTensorBoardCollection(Collection<TensorBoard> tensorBoardCollection) {
        this.tensorBoardCollection = tensorBoardCollection;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<DefaultJobConfiguration> getDefaultJobConfigurationCollection() {
        return this.defaultJobConfigurationCollection;
    }

    public void setDefaultJobConfigurationCollection(Collection<DefaultJobConfiguration> defaultJobConfigurationCollection) {
        this.defaultJobConfigurationCollection = defaultJobConfigurationCollection;
    }

    public Date getLastQuotaUpdate() {
        return this.lastQuotaUpdate;
    }

    public void setLastQuotaUpdate(Date lastQuotaUpdate) {
        this.lastQuotaUpdate = lastQuotaUpdate;
    }

    public Integer getKafkaMaxNumTopics() {
        return this.kafkaMaxNumTopics;
    }

    public void setKafkaMaxNumTopics(Integer kafkaMaxNumTopics) {
        this.kafkaMaxNumTopics = kafkaMaxNumTopics;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public PythonEnvironment getPythonEnvironment() {
        return this.pythonEnvironment;
    }

    public void setPythonEnvironment(PythonEnvironment pythonEnvironment) {
        this.pythonEnvironment = pythonEnvironment;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<ProjectServiceAlert> getProjectServiceAlerts() {
        return this.projectServiceAlerts;
    }

    public void setProjectServiceAlerts(Collection<ProjectServiceAlert> projectServiceAlerts) {
        this.projectServiceAlerts = projectServiceAlerts;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<Jobs> getJobsCollection() {
        return this.jobsCollection;
    }

    public void setJobsCollection(Collection<Jobs> jobsCollection) {
        this.jobsCollection = jobsCollection;
    }

    public String toString() {
        return "Project{projectTeamCollection=" + this.projectTeamCollection + ", activityCollection=" + this.activityCollection + ", projectServicesCollection=" + this.projectServicesCollection + ", datasetCollection=" + this.datasetCollection + ", datasetSharedWithCollection=" + this.datasetSharedWithCollection + ", condaCommandsCollection=" + this.condaCommandsCollection + ", servingCollection=" + this.servingCollection + ", tensorBoardCollection=" + this.tensorBoardCollection + ", defaultJobConfigurationCollection=" + this.defaultJobConfigurationCollection + ", jobsCollection=" + this.jobsCollection + ", id=" + this.id + ", name='" + this.name + '\'' + ", owner=" + this.owner + ", pythonEnvironment=" + this.pythonEnvironment + ", created=" + this.created + ", paymentType=" + (Object)((Object)this.paymentType) + ", description='" + this.description + '\'' + ", kafkaMaxNumTopics=" + this.kafkaMaxNumTopics + ", lastQuotaUpdate=" + this.lastQuotaUpdate + ", dockerImage='" + this.dockerImage + '\'' + ", topicName='" + this.topicName + '\'' + ", creationStatus=" + (Object)((Object)this.creationStatus) + ", pythonDepCollection=" + this.pythonDepCollection + ", jupyterProjectCollection=" + this.jupyterProjectCollection + ", projectServiceAlerts=" + this.projectServiceAlerts + '}';
    }
}

