/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.user.security.apiKey;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum ApiScope {
    JOB(false, true),
    DATASET_VIEW(false, true),
    DATASET_CREATE(false, true),
    DATASET_DELETE(false, true),
    SERVING(false, true),
    FEATURESTORE(false, true),
    PROJECT(false, true),
    ADMIN(true, false),
    KAFKA(false, true),
    ADMINISTER_USERS(true, false),
    ADMINISTER_USERS_REGISTER(true, false),
    MODELREGISTRY(false, true),
    USER(false, true),
    GIT(false, false),
    PYTHON_LIBRARIES(false, false),
    AUTH(true, false);

    private final boolean privileged;
    private final boolean saas;
    private static final Set<ApiScope> AGENT_SCOPES;

    private ApiScope(boolean privileged, boolean saas) {
        this.privileged = privileged;
        this.saas = saas;
    }

    public static ApiScope fromString(String param) {
        return ApiScope.valueOf(param.toUpperCase());
    }

    public static Set<ApiScope> getAll() {
        return new HashSet<ApiScope>(Arrays.asList(ApiScope.values()));
    }

    public static Set<ApiScope> getPrivileged() {
        return Arrays.stream(ApiScope.values()).filter(as -> as.privileged).collect(Collectors.toSet());
    }

    public static Set<ApiScope> getUnprivileged() {
        return Arrays.stream(ApiScope.values()).filter(as -> !as.privileged).collect(Collectors.toSet());
    }

    public static Set<ApiScope> getServiceUserScopes() {
        return Arrays.stream(ApiScope.values()).filter(as -> as.saas).collect(Collectors.toSet());
    }

    public static Set<ApiScope> getAgentUserScopes() {
        Set<ApiScope> unprivileged = ApiScope.getUnprivileged();
        unprivileged.addAll(AGENT_SCOPES);
        return unprivileged;
    }

    static {
        AGENT_SCOPES = Sets.newHashSet((Object[])new ApiScope[]{AUTH});
    }
}

