/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.project.jobs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.hops.hopsworks.persistence.entity.jobs.configuration.DefaultJobConfigurationPK;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfigurationConverter;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@XmlRootElement
@Table(name="default_job_configuration", catalog="hopsworks", schema="")
public class DefaultJobConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private DefaultJobConfigurationPK defaultJobConfigurationPK;
    @JoinColumn(name="project_id", referencedColumnName="id", insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Project project;
    @Column(name="config")
    @Convert(converter=JobConfigurationConverter.class)
    @SuppressFBWarnings(justification="Converter", value={"SE_BAD_FIELD"})
    private JobConfiguration jobConfig;

    public DefaultJobConfiguration() {
    }

    public DefaultJobConfiguration(Project project, JobType jobType, JobConfiguration jobConfiguration) {
        this.setDefaultJobConfigurationPK(new DefaultJobConfigurationPK(project.getId(), jobType));
        this.setJobConfig(jobConfiguration);
    }

    public DefaultJobConfigurationPK getDefaultJobConfigurationPK() {
        return this.defaultJobConfigurationPK;
    }

    public void setDefaultJobConfigurationPK(DefaultJobConfigurationPK defaultJobConfigurationPK) {
        this.defaultJobConfigurationPK = defaultJobConfigurationPK;
    }

    public JobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    public void setJobConfig(JobConfiguration jobConfig) {
        this.jobConfig = jobConfig;
    }

    public int hashCode() {
        return Objects.hash(this.defaultJobConfigurationPK);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultJobConfiguration)) {
            return false;
        }
        DefaultJobConfiguration other = (DefaultJobConfiguration)object;
        return this.defaultJobConfigurationPK.equals(other.defaultJobConfigurationPK);
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

