/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.featuregroup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Embedding;
import io.hops.hopsworks.persistence.entity.models.version.ModelVersion;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="embedding_feature", catalog="hopsworks")
@XmlRootElement
public class EmbeddingFeature
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="embedding_id", referencedColumnName="id")
    private Embedding embedding;
    @Column
    private String name;
    @Column
    private Integer dimension;
    @Column(name="similarity_function_type")
    private String similarityFunctionType;
    @JoinColumn(name="model_version_id", referencedColumnName="id")
    @OneToOne
    private ModelVersion modelVersion;

    public EmbeddingFeature() {
    }

    public EmbeddingFeature(Embedding embedding, String name, Integer dimension, String similarityFunctionType) {
        this.embedding = embedding;
        this.name = name;
        this.dimension = dimension;
        this.similarityFunctionType = similarityFunctionType;
    }

    public EmbeddingFeature(Embedding embedding, String name, Integer dimension, String similarityFunctionType, ModelVersion modelVersion) {
        this.embedding = embedding;
        this.name = name;
        this.dimension = dimension;
        this.similarityFunctionType = similarityFunctionType;
        this.modelVersion = modelVersion;
    }

    public EmbeddingFeature(Integer id, Embedding embedding, String name, Integer dimension, String similarityFunctionType) {
        this.id = id;
        this.embedding = embedding;
        this.name = name;
        this.dimension = dimension;
        this.similarityFunctionType = similarityFunctionType;
    }

    public Integer getId() {
        return this.id;
    }

    public Embedding getEmbedding() {
        return this.embedding;
    }

    public String getName() {
        return this.name;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public String getSimilarityFunctionType() {
        return this.similarityFunctionType;
    }

    public ModelVersion getModelVersion() {
        return this.modelVersion;
    }

    @JsonIgnore
    public String getFieldName() {
        return this.embedding.getColPrefix() == null ? this.name : this.embedding.getColPrefix() + this.name;
    }
}

