/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.statistics;

import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.EntityStatistics;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureDescriptiveStatistics;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="feature_view_statistics", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="FeatureViewStatistics.findAll", query="SELECT fgs FROM FeatureViewStatistics fgs"), @NamedQuery(name="FeatureViewStatistics.findById", query="SELECT s FROM FeatureViewStatistics s WHERE s.id = :id")})
public class FeatureViewStatistics
extends EntityStatistics {
    @JoinTable(name="hopsworks.feature_view_descriptive_statistics", joinColumns={@JoinColumn(name="feature_view_statistics_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="feature_descriptive_statistics_id", referencedColumnName="id")})
    @ManyToMany(fetch=FetchType.LAZY)
    private Collection<FeatureDescriptiveStatistics> featureDescriptiveStatistics;
    @JoinColumn(name="feature_view_id", referencedColumnName="id")
    private FeatureView featureView;
    @Basic(optional=false)
    @Column(name="window_start_commit_time")
    @NotNull
    private Long windowStartCommitTime;
    @Basic(optional=false)
    @Column(name="window_end_commit_time")
    @NotNull
    private Long windowEndCommitTime;

    public FeatureViewStatistics() {
    }

    public FeatureViewStatistics(Date computationTime, Float rowPercentage, Collection<FeatureDescriptiveStatistics> featureDescriptiveStatistics, FeatureView featureView) {
        super(computationTime, rowPercentage);
        this.featureView = featureView;
        this.featureDescriptiveStatistics = featureDescriptiveStatistics;
        this.windowStartCommitTime = 0L;
        this.windowEndCommitTime = computationTime.getTime();
    }

    public FeatureViewStatistics(Date computationTime, Long windowStartCommitTime, Long windowEndCommitTime, Float rowPercentage, Collection<FeatureDescriptiveStatistics> featureDescriptiveStatistics, FeatureView featureView) {
        super(computationTime, rowPercentage);
        this.featureView = featureView;
        this.featureDescriptiveStatistics = featureDescriptiveStatistics;
        this.windowStartCommitTime = windowStartCommitTime;
        this.windowEndCommitTime = windowEndCommitTime;
    }

    public Collection<FeatureDescriptiveStatistics> getFeatureDescriptiveStatistics() {
        return this.featureDescriptiveStatistics;
    }

    public void setFeatureDescriptiveStatistics(Collection<FeatureDescriptiveStatistics> featureDescriptiveStatistics) {
        this.featureDescriptiveStatistics = featureDescriptiveStatistics;
    }

    public FeatureView getFeatureView() {
        return this.featureView;
    }

    public void setFeatureView(FeatureView featureView) {
        this.featureView = featureView;
    }

    public Long getWindowStartCommitTime() {
        return this.windowStartCommitTime;
    }

    public void setWindowStartCommitTime(Long windowStartCommitTime) {
        this.windowStartCommitTime = windowStartCommitTime;
    }

    public Long getWindowEndCommitTime() {
        return this.windowEndCommitTime;
    }

    public void setWindowEndCommitTime(Long windowEndCommitTime) {
        this.windowEndCommitTime = windowEndCommitTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureViewStatistics that = (FeatureViewStatistics)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.featureView, that.featureView)) {
            return false;
        }
        if (!Objects.equals(this.windowStartCommitTime, that.windowStartCommitTime)) {
            return false;
        }
        return Objects.equals(this.windowEndCommitTime, that.windowEndCommitTime);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.featureView != null ? this.featureView.hashCode() : 0);
        result = 31 * result + (this.windowStartCommitTime != null ? this.windowStartCommitTime.hashCode() : 0);
        result = 31 * result + (this.windowEndCommitTime != null ? this.windowEndCommitTime.hashCode() : 0);
        return result;
    }
}

