/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.result;

import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.FeatureMonitoringConfiguration;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureDescriptiveStatistics;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="feature_monitoring_result", catalog="hopsworks")
@NamedQueries(value={@NamedQuery(name="FeatureMonitoringResult.findByResultId", query="SELECT result FROM FeatureMonitoringResult result WHERE result.id=:resultId")})
@XmlRootElement
public class FeatureMonitoringResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="feature_monitoring_config_id", nullable=false, referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private FeatureMonitoringConfiguration featureMonitoringConfig;
    @Basic
    @Column(name="execution_id")
    @NotNull
    private Integer executionId;
    @Basic(optional=false)
    @Column(name="detection_stats_id", updatable=false)
    @NotNull
    private Integer detectionStatsId;
    @Basic
    @Column(name="reference_stats_id", updatable=false)
    private Integer referenceStatsId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="detection_stats_id", referencedColumnName="id", updatable=false, insertable=false)
    private FeatureDescriptiveStatistics detectionStatistics;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="reference_stats_id", referencedColumnName="id", updatable=false, insertable=false)
    private FeatureDescriptiveStatistics referenceStatistics;
    @Basic
    @Column(name="difference")
    private Double difference;
    @Basic
    @Column(name="specific_value")
    private Double specificValue;
    @Basic
    @Column(name="monitoring_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    private Date monitoringTime;
    @Basic
    @Column(name="shift_detected")
    private Boolean shiftDetected;
    @Basic
    @Column(name="feature_name")
    @Size(max=63)
    private @Size(max=63) String featureName;
    @Basic
    @Column(name="raised_exception")
    private Boolean raisedException;
    @Basic
    @Column(name="empty_detection_window")
    private Boolean emptyDetectionWindow;
    @Basic
    @Column(name="empty_reference_window")
    private Boolean emptyReferenceWindow;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public FeatureMonitoringConfiguration getFeatureMonitoringConfig() {
        return this.featureMonitoringConfig;
    }

    public void setFeatureMonitoringConfig(FeatureMonitoringConfiguration featureMonitoringConfig) {
        this.featureMonitoringConfig = featureMonitoringConfig;
    }

    public Integer getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(Integer executionId) {
        this.executionId = executionId;
    }

    public Integer getDetectionStatsId() {
        return this.detectionStatsId;
    }

    public void setDetectionStatsId(Integer detectionStatsId) {
        this.detectionStatsId = detectionStatsId;
    }

    public Integer getReferenceStatsId() {
        return this.referenceStatsId;
    }

    public void setReferenceStatsId(Integer referenceStatsId) {
        this.referenceStatsId = referenceStatsId;
    }

    public FeatureDescriptiveStatistics getDetectionStatistics() {
        return this.detectionStatistics;
    }

    public FeatureDescriptiveStatistics getReferenceStatistics() {
        return this.referenceStatistics;
    }

    public Double getDifference() {
        return this.difference;
    }

    public void setDifference(Double difference) {
        this.difference = difference;
    }

    public Double getSpecificValue() {
        return this.specificValue;
    }

    public void setSpecificValue(Double specificValue) {
        this.specificValue = specificValue;
    }

    public Date getMonitoringTime() {
        return this.monitoringTime;
    }

    public void setMonitoringTime(Date monitoringTime) {
        this.monitoringTime = monitoringTime;
    }

    public Boolean getShiftDetected() {
        return this.shiftDetected;
    }

    public void setShiftDetected(Boolean shiftDetected) {
        this.shiftDetected = shiftDetected;
    }

    public Boolean getRaisedException() {
        return this.raisedException;
    }

    public void setRaisedException(Boolean raisedException) {
        this.raisedException = raisedException;
    }

    public Boolean getEmptyDetectionWindow() {
        return this.emptyDetectionWindow;
    }

    public void setEmptyDetectionWindow(Boolean emptyDetectionWindow) {
        this.emptyDetectionWindow = emptyDetectionWindow;
    }

    public Boolean getEmptyReferenceWindow() {
        return this.emptyReferenceWindow;
    }

    public void setEmptyReferenceWindow(Boolean emptyReferenceWindow) {
        this.emptyReferenceWindow = emptyReferenceWindow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureMonitoringResult)) {
            return false;
        }
        FeatureMonitoringResult featureMonitoringResult = (FeatureMonitoringResult)o;
        return Objects.equals(this.id, featureMonitoringResult.id) && Objects.equals(this.featureMonitoringConfig.getId(), featureMonitoringResult.featureMonitoringConfig.getId()) && Objects.equals(this.detectionStatsId, featureMonitoringResult.detectionStatsId) && Objects.equals(this.referenceStatsId, featureMonitoringResult.referenceStatsId) && Objects.equals(this.difference, featureMonitoringResult.difference) && Objects.equals(this.specificValue, featureMonitoringResult.specificValue) && Objects.equals(this.shiftDetected, featureMonitoringResult.shiftDetected) && Objects.equals(this.featureName, featureMonitoringResult.featureName) && Objects.equals(this.monitoringTime, featureMonitoringResult.monitoringTime) && Objects.equals(this.raisedException, featureMonitoringResult.raisedException) && Objects.equals(this.emptyDetectionWindow, featureMonitoringResult.emptyDetectionWindow) && Objects.equals(this.emptyReferenceWindow, featureMonitoringResult.emptyReferenceWindow);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.difference, this.specificValue, this.monitoringTime, this.shiftDetected, this.raisedException, this.emptyDetectionWindow, this.emptyReferenceWindow);
    }
}

