/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.statistics;

import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.EntityStatistics;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureDescriptiveStatistics;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="feature_group_statistics", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="FeatureGroupStatistics.findAll", query="SELECT fgs FROM FeatureGroupStatistics fgs"), @NamedQuery(name="FeatureGroupStatistics.findById", query="SELECT s FROM FeatureGroupStatistics s WHERE s.id = :id")})
public class FeatureGroupStatistics
extends EntityStatistics {
    @JoinTable(name="hopsworks.feature_group_descriptive_statistics", joinColumns={@JoinColumn(name="feature_group_statistics_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="feature_descriptive_statistics_id", referencedColumnName="id")})
    @ManyToMany(fetch=FetchType.LAZY)
    private Collection<FeatureDescriptiveStatistics> featureDescriptiveStatistics;
    @JoinColumn(name="feature_group_id", referencedColumnName="id")
    private Featuregroup featureGroup;
    @Basic(optional=false)
    @Column(name="window_start_commit_time")
    @NotNull
    private Long windowStartCommitTime;
    @Basic(optional=false)
    @Column(name="window_end_commit_time")
    @NotNull
    private Long windowEndCommitTime;

    public FeatureGroupStatistics() {
    }

    public FeatureGroupStatistics(Date computationTime, Float rowPercentage, Collection<FeatureDescriptiveStatistics> featureDescriptiveStatistics, Featuregroup featureGroup) {
        super(computationTime, rowPercentage);
        this.featureGroup = featureGroup;
        this.featureDescriptiveStatistics = featureDescriptiveStatistics;
        this.windowStartCommitTime = 0L;
        this.windowEndCommitTime = computationTime.getTime();
    }

    public FeatureGroupStatistics(Date computationTime, Long windowStartCommitTime, Long windowEndCommitTime, Float rowPercentage, Collection<FeatureDescriptiveStatistics> featureDescriptiveStatistics, Featuregroup featuregroup) {
        super(computationTime, rowPercentage);
        this.featureGroup = featuregroup;
        this.featureDescriptiveStatistics = featureDescriptiveStatistics;
        this.windowStartCommitTime = windowStartCommitTime;
        this.windowEndCommitTime = windowEndCommitTime;
    }

    public Collection<FeatureDescriptiveStatistics> getFeatureDescriptiveStatistics() {
        return this.featureDescriptiveStatistics;
    }

    public void setFeatureDescriptiveStatistics(Collection<FeatureDescriptiveStatistics> featureDescriptiveStatistics) {
        this.featureDescriptiveStatistics = featureDescriptiveStatistics;
    }

    public Featuregroup getFeatureGroup() {
        return this.featureGroup;
    }

    public void setFeatureGroup(Featuregroup featureGroup) {
        this.featureGroup = featureGroup;
    }

    public Long getWindowStartCommitTime() {
        return this.windowStartCommitTime;
    }

    public void setWindowStartCommitTime(Long windowStartCommitTime) {
        this.windowStartCommitTime = windowStartCommitTime;
    }

    public Long getWindowEndCommitTime() {
        return this.windowEndCommitTime;
    }

    public void setWindowEndCommitTime(Long windowEndCommitTime) {
        this.windowEndCommitTime = windowEndCommitTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureGroupStatistics that = (FeatureGroupStatistics)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.featureGroup, that.featureGroup)) {
            return false;
        }
        if (!Objects.equals(this.windowStartCommitTime, that.windowStartCommitTime)) {
            return false;
        }
        return Objects.equals(this.windowEndCommitTime, that.windowEndCommitTime);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.featureGroup != null ? this.featureGroup.hashCode() : 0);
        result = 31 * result + (this.windowStartCommitTime != null ? this.windowStartCommitTime.hashCode() : 0);
        result = 31 * result + (this.windowEndCommitTime != null ? this.windowEndCommitTime.hashCode() : 0);
        return result;
    }
}

