/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.storageconnector.kafka;

import java.util.Arrays;
import java.util.Optional;

public enum SSLEndpointIdentificationAlgorithm {
    HTTPS("HTTPS"),
    EMPTY("");

    private String value;

    private SSLEndpointIdentificationAlgorithm(String value) {
        this.value = value;
    }

    public static SSLEndpointIdentificationAlgorithm fromString(String value) {
        Optional<SSLEndpointIdentificationAlgorithm> algorithm = Arrays.stream(SSLEndpointIdentificationAlgorithm.values()).filter(a -> a.getValue().equals(value.toUpperCase())).findFirst();
        if (algorithm.isPresent()) {
            return algorithm.get();
        }
        throw new IllegalArgumentException("Invalid ssl endpoint identification algorithm provided");
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

