/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3;

import java.util.Arrays;
import java.util.Optional;

public enum FeaturestoreS3ConnectorEncryptionAlgorithm {
    AES256("AES256", "Server-Side Encryption with Amazon S3-Managed Keys (SSE-S3)", false),
    SSE_KMS("SSE-KMS", "Server-Encryption with AWS KMS-Managed Keys (SSE-KMS)", true);

    private String algorithm;
    private String description;
    private boolean requiresKey;

    private FeaturestoreS3ConnectorEncryptionAlgorithm(String algorithm, String description, boolean requiresKey) {
        this.algorithm = algorithm;
        this.description = description;
        this.requiresKey = requiresKey;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequiresKey() {
        return this.requiresKey;
    }

    public static FeaturestoreS3ConnectorEncryptionAlgorithm fromValue(String s) throws IllegalArgumentException {
        Optional<FeaturestoreS3ConnectorEncryptionAlgorithm> algorithm = Arrays.asList(FeaturestoreS3ConnectorEncryptionAlgorithm.values()).stream().filter(a -> a.getAlgorithm().equals(s)).findFirst();
        if (algorithm.isPresent()) {
            return algorithm.get();
        }
        throw new IllegalArgumentException("Invalid encryption algorithm provided");
    }

    public String toString() {
        return this.algorithm;
    }
}

