/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.project.team;

import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeamPK;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="project_team", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="ProjectTeam.findRoleForUserInProject", query="SELECT s FROM ProjectTeam s WHERE s.project = :project AND s.user = :user"), @NamedQuery(name="ProjectTeam.findAll", query="SELECT s FROM ProjectTeam s"), @NamedQuery(name="ProjectTeam.findByProject", query="SELECT s FROM ProjectTeam s WHERE s.project = :project"), @NamedQuery(name="ProjectTeam.findActiveByTeamMember", query="SELECT s FROM ProjectTeam s WHERE s.user = :user AND s.teamRole != \"Under removal\" "), @NamedQuery(name="ProjectTeam.findByTeamRole", query="SELECT s FROM ProjectTeam s WHERE s.teamRole = :teamRole"), @NamedQuery(name="ProjectTeam.countStudiesByMember", query="SELECT COUNT(s) FROM ProjectTeam s WHERE s.user = :user"), @NamedQuery(name="ProjectTeam.countMembersForProjectAndRole", query="SELECT COUNT(DISTINCT s.projectTeamPK.teamMember) FROM ProjectTeam s WHERE s.project=:project AND s.teamRole = :teamRole"), @NamedQuery(name="ProjectTeam.countAllMembersForProject", query="SELECT COUNT(DISTINCT s.projectTeamPK.teamMember) FROM ProjectTeam s WHERE s.project = :project"), @NamedQuery(name="ProjectTeam.findMembersByRoleInProject", query="SELECT s FROM ProjectTeam s WHERE s.project = :project AND s.teamRole = :teamRole"), @NamedQuery(name="ProjectTeam.findAllMemberStudiesForUser", query="SELECT st.project from ProjectTeam st WHERE st.user = :user"), @NamedQuery(name="ProjectTeam.findAllJoinedStudiesForUser", query="SELECT st.project from ProjectTeam st WHERE st.user = :user AND NOT st.project.owner = :user")})
public class ProjectTeam
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="project_id", referencedColumnName="id", insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Project project;
    @JoinColumn(name="team_member", referencedColumnName="email", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    private Users user;
    @EmbeddedId
    protected ProjectTeamPK projectTeamPK;
    @Column(name="team_role")
    private String teamRole;
    @Basic(optional=false)
    @NotNull
    @Column(name="added")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timestamp;

    public ProjectTeam() {
    }

    public ProjectTeam(ProjectTeamPK projectTeamPK) {
        this.projectTeamPK = projectTeamPK;
    }

    public ProjectTeam(ProjectTeamPK projectTeamPK, Date timestamp) {
        this.projectTeamPK = projectTeamPK;
        this.timestamp = timestamp;
    }

    public ProjectTeam(Project project, Users user) {
        this.projectTeamPK = new ProjectTeamPK(project.getId(), user.getEmail());
    }

    public ProjectTeamPK getProjectTeamPK() {
        return this.projectTeamPK;
    }

    public void setProjectTeamPK(ProjectTeamPK projectTeamPK) {
        this.projectTeamPK = projectTeamPK;
    }

    public String getTeamRole() {
        return this.teamRole;
    }

    public void setTeamRole(String teamRole) {
        this.teamRole = teamRole;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.projectTeamPK != null ? this.projectTeamPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProjectTeam)) {
            return false;
        }
        ProjectTeam other = (ProjectTeam)object;
        return (this.projectTeamPK != null || other.projectTeamPK == null) && (this.projectTeamPK == null || this.projectTeamPK.equals(other.projectTeamPK));
    }

    public String toString() {
        return "ProjectTeam{projectTeamPK=" + this.projectTeamPK + '}';
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Users getUser() {
        return this.user;
    }

    public void setUser(Users user) {
        this.user = user;
    }
}

