/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.provenance;

import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.models.version.ModelVersion;
import io.hops.hopsworks.persistence.entity.provenance.ProvExplicitNode;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="model_link", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="ModelLink.findByChildren", query="SELECT l FROM ModelLink l LEFT JOIN FETCH l.parentTrainingDataset WHERE l.model IN :children ORDER BY l.parentTrainingDataset ASC, l.id DESC"), @NamedQuery(name="ModelLink.findByParents", query="SELECT l FROM ModelLink l LEFT JOIN FETCH l.model WHERE l.parentTrainingDataset IN :parents ORDER BY l.model.model.name ASC, l.model.version DESC, l.id DESC")})
public class ModelLink
implements ProvExplicitNode,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="model_version_id", referencedColumnName="id")
    @OneToOne(fetch=FetchType.LAZY)
    private ModelVersion model;
    @JoinColumn(name="parent_training_dataset_id", referencedColumnName="id")
    @OneToOne(fetch=FetchType.LAZY)
    private TrainingDataset parentTrainingDataset;
    @Basic(optional=false)
    @Column(name="parent_feature_store")
    private String parentFeatureStore;
    @Basic(optional=false)
    @Column(name="parent_feature_view_name")
    private String parentFeatureViewName;
    @Basic(optional=false)
    @Column(name="parent_feature_view_version")
    private Integer parentFeatureViewVersion;
    @Basic(optional=false)
    @Column(name="parent_training_dataset_version")
    private Integer parentTrainingDatasetVersion;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ModelVersion getModel() {
        return this.model;
    }

    public void setModel(ModelVersion model) {
        this.model = model;
    }

    public TrainingDataset getParentTrainingDataset() {
        return this.parentTrainingDataset;
    }

    public void setParentTrainingDataset(TrainingDataset parentTrainingDataset) {
        this.parentTrainingDataset = parentTrainingDataset;
    }

    public String getParentFeatureStore() {
        return this.parentFeatureStore;
    }

    public void setParentFeatureStore(String parentFeatureStore) {
        this.parentFeatureStore = parentFeatureStore;
    }

    public String getParentFeatureViewName() {
        return this.parentFeatureViewName;
    }

    public void setParentFeatureViewName(String parentFeatureViewName) {
        this.parentFeatureViewName = parentFeatureViewName;
    }

    public Integer getParentFeatureViewVersion() {
        return this.parentFeatureViewVersion;
    }

    public void setParentFeatureViewVersion(Integer parentFeatureViewVersion) {
        this.parentFeatureViewVersion = parentFeatureViewVersion;
    }

    public Integer getParentTrainingDatasetVersion() {
        return this.parentTrainingDatasetVersion;
    }

    public void setParentTrainingDatasetVersion(Integer parentTrainingDatasetVersion) {
        this.parentTrainingDatasetVersion = parentTrainingDatasetVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelLink)) {
            return false;
        }
        ModelLink modelLink = (ModelLink)o;
        return this.id.equals(modelLink.id) && this.model.equals(modelLink.model) && this.parentTrainingDataset.equals(modelLink.parentTrainingDataset) && this.parentFeatureStore.equals(modelLink.parentFeatureStore) && this.parentFeatureViewName.equals(modelLink.parentFeatureViewName) && this.parentFeatureViewVersion.equals(modelLink.parentFeatureViewVersion) && this.parentTrainingDatasetVersion.equals(modelLink.parentTrainingDatasetVersion);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.model, this.parentTrainingDataset, this.parentFeatureStore, this.parentFeatureViewName, this.parentFeatureViewVersion, this.parentTrainingDatasetVersion);
    }

    @Override
    public String parentProject() {
        return this.parentFeatureStore;
    }

    @Override
    public String parentName() {
        return this.parentFeatureViewName + "_" + this.parentFeatureViewVersion;
    }

    @Override
    public Integer parentVersion() {
        return this.parentTrainingDatasetVersion;
    }

    @Override
    public Integer parentId() {
        return this.parentTrainingDataset != null ? this.parentTrainingDataset.getId() : null;
    }
}

