/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.git.config;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum GitOpExecutionState {
    INITIALIZING("Initializing"),
    INITIALIZATION_FAILED("Initialization failed"),
    SUCCESS("Success"),
    RUNNING("Running"),
    FAILED("Failed"),
    KILLED("Killed"),
    SUBMITTED("Submitted"),
    TIMEDOUT("Timedout"),
    CANCELLED("Cancelled");

    private final String executionState;

    private GitOpExecutionState(String executionState) {
        this.executionState = executionState;
    }

    public String toString() {
        return this.executionState;
    }

    public String getExecutionState() {
        return this.executionState;
    }

    public static GitOpExecutionState fromValue(String v) throws IllegalArgumentException {
        return Arrays.stream(GitOpExecutionState.values()).filter(s -> s.getExecutionState().equalsIgnoreCase(v.toUpperCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid git operation execution state provided"));
    }

    public boolean isFinalState() {
        switch (this) {
            case SUCCESS: 
            case FAILED: 
            case KILLED: 
            case INITIALIZATION_FAILED: 
            case TIMEDOUT: 
            case CANCELLED: {
                return true;
            }
        }
        return false;
    }

    public static Set<GitOpExecutionState> getFinalStates() {
        return EnumSet.of(SUCCESS, new GitOpExecutionState[]{FAILED, KILLED, INITIALIZATION_FAILED, TIMEDOUT, CANCELLED});
    }
}

