/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.jobs.description;

import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobFinalStatus;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobState;
import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum JobAlertStatus {
    FINISHED("Finished"),
    FAILED("Failed"),
    KILLED("Killed");

    private final String name;

    private JobAlertStatus(String name) {
        this.name = name;
    }

    public static JobAlertStatus fromString(String name) {
        return JobAlertStatus.valueOf(name.toUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public static JobAlertStatus getJobAlertStatus(JobState jobState) {
        switch (jobState) {
            case FINISHED: {
                return FINISHED;
            }
            case FAILED: 
            case FRAMEWORK_FAILURE: 
            case APP_MASTER_START_FAILED: 
            case INITIALIZATION_FAILED: {
                return FAILED;
            }
            case KILLED: {
                return KILLED;
            }
        }
        throw new IllegalArgumentException("Invalid enum constant");
    }

    public static JobAlertStatus getJobAlertStatus(JobFinalStatus jobFinalStatus) {
        switch (jobFinalStatus) {
            case SUCCEEDED: {
                return FINISHED;
            }
            case FAILED: {
                return FAILED;
            }
            case KILLED: {
                return KILLED;
            }
        }
        throw new IllegalArgumentException("Invalid enum constant");
    }
}

