/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.models.version;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.hops.hopsworks.persistence.entity.models.version.Metrics;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.json.JSONObject;

@Converter
public class ModelMetricsConverter
implements AttributeConverter<Metrics, String> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger LOGGER = Logger.getLogger(ModelMetricsConverter.class.getName());

    public ModelMetricsConverter() {
        this.objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        this.objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, false);
    }

    public <T> T readValue(String jsonConfig, Class<T> resultClass) throws JsonProcessingException {
        if (jsonConfig == null) {
            jsonConfig = new JSONObject().toString();
        }
        return (T)this.objectMapper.readValue(jsonConfig, resultClass);
    }

    public String writeValue(Object value) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(value);
    }

    public String convertToDatabaseColumn(Metrics metrics) {
        String jsonConfig;
        try {
            jsonConfig = this.writeValue(metrics);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to marshal value:" + metrics, e);
        }
        return jsonConfig;
    }

    public Metrics convertToEntityAttribute(String jsonConfig) {
        try {
            return this.readValue(jsonConfig, Metrics.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to unmarshal value:" + jsonConfig, e);
        }
    }
}

