/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.dataset;

import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.message.Message;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="dataset_request", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="DatasetRequest.findAll", query="SELECT d FROM DatasetRequest d"), @NamedQuery(name="DatasetRequest.findById", query="SELECT d FROM DatasetRequest d WHERE d.id = :id"), @NamedQuery(name="DatasetRequest.findByDataset", query="SELECT d FROM DatasetRequest d WHERE d.dataset = :dataset"), @NamedQuery(name="DatasetRequest.findByProjectTeam", query="SELECT d FROM DatasetRequest d WHERE d.projectTeam = :projectTeam"), @NamedQuery(name="DatasetRequest.findByProjectTeamAndDataset", query="SELECT d FROM DatasetRequest d WHERE d.projectTeam = :projectTeam AND d.dataset = :dataset"), @NamedQuery(name="DatasetRequest.findByProjectAndDataset", query="SELECT d FROM DatasetRequest d WHERE d.projectTeam.project = :project AND d.dataset = :dataset"), @NamedQuery(name="DatasetRequest.findByRequested", query="SELECT d FROM DatasetRequest d WHERE d.requested = :requested"), @NamedQuery(name="DatasetRequest.findByMessage", query="SELECT d FROM DatasetRequest d WHERE d.messageContent = :message"), @NamedQuery(name="DatasetRequest.findByMessageId", query="SELECT d FROM DatasetRequest d WHERE d.message.id = :message_id")})
public class DatasetRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Column(name="requested")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date requested;
    @Size(max=2000)
    @Column(name="message")
    private @Size(max=2000) String messageContent;
    @JoinColumn(name="dataset", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Dataset dataset;
    @JoinColumns(value={@JoinColumn(name="projectId", referencedColumnName="project_id"), @JoinColumn(name="user_email", referencedColumnName="team_member")})
    @ManyToOne(optional=false)
    private ProjectTeam projectTeam;
    @JoinColumn(name="message_id", referencedColumnName="id")
    @OneToOne
    private Message message;

    public DatasetRequest() {
    }

    public DatasetRequest(Integer id) {
        this.id = id;
    }

    public DatasetRequest(Integer id, Date requested) {
        this.id = id;
        this.requested = requested;
    }

    public DatasetRequest(Dataset dataset, ProjectTeam projectTeam, String messageContent) {
        this.messageContent = messageContent;
        this.dataset = dataset;
        this.projectTeam = projectTeam;
        this.requested = new Date();
    }

    public DatasetRequest(Dataset dataset, ProjectTeam projectTeam, String messageContent, Message message) {
        this.messageContent = messageContent;
        this.message = message;
        this.dataset = dataset;
        this.projectTeam = projectTeam;
        this.requested = new Date();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getRequested() {
        return this.requested;
    }

    public void setRequested(Date requested) {
        this.requested = requested;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(String message) {
        this.messageContent = message;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public ProjectTeam getProjectTeam() {
        return this.projectTeam;
    }

    public void setProjectTeam(ProjectTeam projectTeam) {
        this.projectTeam = projectTeam;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatasetRequest)) {
            return false;
        }
        DatasetRequest other = (DatasetRequest)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "se.kth.hopsworks.dataset.DatasetRequest[ id=" + this.id + " ]";
    }
}

