/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.models.version;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.hops.hopsworks.persistence.entity.models.Model;
import io.hops.hopsworks.persistence.entity.models.version.Metrics;
import io.hops.hopsworks.persistence.entity.models.version.ModelMetricsConverter;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="model_version", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="ModelVersion.findAll", query="SELECT mv FROM ModelVersion mv"), @NamedQuery(name="ModelVersion.findByProjectAndMlId", query="SELECT mv FROM ModelVersion mv WHERE mv.version = :version AND mv.model.id = :modelId")})
public class ModelVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @Column(name="version")
    private Integer version;
    @ManyToOne(optional=false)
    @JoinColumn(name="model_id", referencedColumnName="id")
    private Model model;
    @JoinColumn(name="user_id", referencedColumnName="uid")
    @ManyToOne(optional=false)
    private Users creator;
    @Basic(optional=false)
    @NotNull
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @Size(max=1000)
    @Column(name="description")
    private @Size(max=1000) String description;
    @Column(name="metrics")
    @Convert(converter=ModelMetricsConverter.class)
    @SuppressFBWarnings(justification="Converter", value={"SE_BAD_FIELD"})
    private Metrics metrics;
    @Size(max=1000)
    @Column(name="program")
    private @Size(max=1000) String program;
    @Size(max=128)
    @Column(name="framework")
    private @Size(max=128) String framework;
    @Size(max=1000)
    @Column(name="environment")
    private @Size(max=1000) String environment;
    @Size(max=128)
    @Column(name="experiment_id")
    private @Size(max=128) String experimentId;
    @Size(max=128)
    @Column(name="experiment_project_name")
    private @Size(max=128) String experimentProjectName;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String program) {
        this.program = program;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getUserFullName() {
        return this.creator.getFname() + " " + this.creator.getLname();
    }

    public String getFramework() {
        return this.framework;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public String getExperimentProjectName() {
        return this.experimentProjectName;
    }

    public void setExperimentProjectName(String experimentProjectName) {
        this.experimentProjectName = experimentProjectName;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public String getMlId() {
        return this.model.getName() + "_" + this.version;
    }

    public Users getCreator() {
        return this.creator;
    }

    public void setCreator(Users creator) {
        this.creator = creator;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ModelVersion)) {
            return false;
        }
        ModelVersion other = (ModelVersion)object;
        return (this.id != null || other.id == null) && (this.id == null || Objects.equals(this.id, other.id));
    }
}

