/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.realm.jdbc;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.Password;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.ee.auth.realm.DigestRealmBase;
import com.sun.enterprise.util.Utility;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

@Service
public class HopsworksJDBCRealm
extends DigestRealmBase {
    public static final String AUTH_TYPE = "hopsworks-jdbc-realm";
    public static final String PRE_HASHED = "HASHED";
    public static final String PARAM_DATASOURCE_JNDI = "datasource-jndi";
    public static final String PARAM_DB_USER = "db-user";
    public static final String PARAM_DB_PASSWORD = "db-password";
    public static final String PARAM_DIGEST_ALGORITHM = "digest-algorithm";
    public static final String NONE = "none";
    public static final String PARAM_ENCODING = "encoding";
    public static final String HEX = "hex";
    public static final String BASE64 = "base64";
    public static final String DEFAULT_ENCODING = "hex";
    public static final String PARAM_CHARSET = "charset";
    public static final String PARAM_PASSWORD_QUERY = "password-query";
    public static final String PARAM_GROUP_QUERY = "group-query";
    public static final String DEFAULT_PASSWORD_QUERY = "SELECT password FROM hopsworks.users WHERE email = ?";
    public static final String DEFAULT_GROUP_QUERY = "SELECT G.group_name from hopsworks.bbc_group AS G, hopsworks.user_group AS UG, hopsworks.users AS U WHERE U.email=? AND UG.gid = G.gid AND UG.uid = U.uid";
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private String passwordQuery;
    private String groupQuery;
    private Map<String, Vector<String>> groupCache;
    private Vector<String> emptyVector;
    private MessageDigest md = null;
    private ActiveDescriptor<ConnectorRuntime> connectorRuntimeDescriptor;

    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String jaasCtx = props.getProperty("jaas-context");
        String dbUser = props.getProperty(PARAM_DB_USER);
        String dbPassword = props.getProperty(PARAM_DB_PASSWORD);
        String dsJndi = props.getProperty(PARAM_DATASOURCE_JNDI);
        String digestAlgorithm = props.getProperty(PARAM_DIGEST_ALGORITHM, this.getDefaultDigestAlgorithm());
        String charset = props.getProperty(PARAM_CHARSET);
        String encoding = props.getProperty(PARAM_ENCODING);
        this.connectorRuntimeDescriptor = this.getConnectorRuntimeDescriptor();
        this.passwordQuery = props.getProperty(PARAM_PASSWORD_QUERY, DEFAULT_PASSWORD_QUERY);
        this.groupQuery = props.getProperty(PARAM_GROUP_QUERY, DEFAULT_GROUP_QUERY);
        if (jaasCtx == null) {
            throw new BadRealmException(sm.getString("realm.missingprop", (Object)"jaas-context", (Object)"JDBCRealm"));
        }
        if (dsJndi == null) {
            throw new BadRealmException(sm.getString("realm.missingprop", (Object)PARAM_DATASOURCE_JNDI, (Object)"JDBCRealm"));
        }
        if (!NONE.equalsIgnoreCase(digestAlgorithm)) {
            try {
                this.md = MessageDigest.getInstance(digestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new BadRealmException(sm.getString("jdbcrealm.notsupportdigestalg", (Object)digestAlgorithm));
            }
        }
        if (this.md != null && encoding == null) {
            encoding = "hex";
        }
        this.setProperty("jaas-context", jaasCtx);
        if (dbUser != null && dbPassword != null) {
            this.setProperty(PARAM_DB_USER, dbUser);
            this.setProperty(PARAM_DB_PASSWORD, dbPassword);
        }
        this.setProperty(PARAM_DATASOURCE_JNDI, dsJndi);
        this.setProperty(PARAM_DIGEST_ALGORITHM, digestAlgorithm);
        if (encoding != null) {
            this.setProperty(PARAM_ENCODING, encoding);
        }
        if (charset != null) {
            this.setProperty(PARAM_CHARSET, charset);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JDBCRealm : jaas-context= " + jaasCtx + ", " + PARAM_DATASOURCE_JNDI + " = " + dsJndi + ", " + PARAM_DB_USER + " = " + dbUser + ", " + PARAM_DIGEST_ALGORITHM + " = " + digestAlgorithm + ", " + PARAM_ENCODING + " = " + encoding + ", " + PARAM_CHARSET + " = " + charset);
        }
        this.groupCache = new HashMap<String, Vector<String>>();
        this.emptyVector = new Vector();
    }

    private ActiveDescriptor<ConnectorRuntime> getConnectorRuntimeDescriptor() {
        return Globals.getStaticHabitat().getBestDescriptor((Filter)BuilderHelper.createContractFilter((String)ConnectorRuntime.class.getName()));
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration<String> getGroupNames(String username) throws InvalidOperationException, NoSuchUserException {
        Vector<String> vector = this.groupCache.get(username);
        if (vector == null) {
            String[] grps = this.findGroups(username);
            this.setGroupNames(username, grps);
            vector = this.groupCache.get(username);
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGroupNames(String username, String[] groups) {
        Vector<String> v = null;
        if (groups == null) {
            v = this.emptyVector;
        } else {
            v = new Vector(groups.length + 1);
            for (String group : groups) {
                v.add(group);
            }
        }
        String[] stringArray = this;
        synchronized (this) {
            this.groupCache.put(username, v);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public String[] authenticate(String username, char[] password) {
        String[] groups = null;
        if (this.isUserValid(username, password)) {
            groups = this.findGroups(username);
            groups = this.addAssignGroups(groups);
            this.setGroupNames(username, groups);
        }
        return groups;
    }

    public boolean validate(String username, DigestAlgorithmParameter[] params) {
        Password pass = this.getPassword(username);
        if (pass == null) {
            return false;
        }
        return this.validate(pass, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Password getPassword(String username) {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        block5: {
            String password;
            block6: {
                connection = null;
                statement = null;
                resultSet = null;
                connection = this.getConnection();
                statement = connection.prepareStatement(this.passwordQuery);
                statement.setString(1, username);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block5;
                password = resultSet.getString(1);
                if (!PRE_HASHED.equalsIgnoreCase(this.getProperty(PARAM_ENCODING))) break block6;
                Password password2 = new Password(){

                    public byte[] getValue() {
                        return password.getBytes();
                    }

                    public int getType() {
                        return 1;
                    }
                };
                this.close(connection, statement, resultSet);
                return password2;
            }
            try {
                Password password3 = new Password(){

                    public byte[] getValue() {
                        return password.getBytes();
                    }

                    public int getType() {
                        return 0;
                    }
                };
                this.close(connection, statement, resultSet);
                return password3;
            }
            catch (Exception ex) {
                try {
                    _logger.log(Level.SEVERE, "jdbcrealm.invaliduser", username);
                    _logger.log(Level.SEVERE, "Cannot validate user", ex);
                    this.close(connection, statement, resultSet);
                }
                catch (Throwable throwable) {
                    this.close(connection, statement, resultSet);
                    throw throwable;
                }
            }
        }
        this.close(connection, statement, resultSet);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean isUserValid(String user, char[] userPassword) {
        connection = null;
        statement = null;
        resultSet = null;
        valid = false;
        try {
            hashedUserPassword = this.hashPassword(userPassword);
            connection = this.getConnection();
            statement = connection.prepareStatement(this.passwordQuery);
            statement.setString(1, user);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                reader = resultSet.getCharacterStream(1);
                var9_11 = null;
                try {
                    pwd = new char[1024];
                    noOfChars = reader.read(pwd);
                    if (noOfChars < 0) {
                        noOfChars = 0;
                    }
                    dbPassword = new char[noOfChars];
                    System.arraycopy(pwd, 0, dbPassword, 0, noOfChars);
                    if ("hex".equalsIgnoreCase(this.getProperty("encoding"))) {
                        valid = true;
                        for (i = 0; i < noOfChars; ++i) {
                            if (Character.toLowerCase(dbPassword[i]) == Character.toLowerCase(hashedUserPassword[i])) continue;
                            valid = false;
                            break;
                        }
                    } else {
                        valid = Arrays.equals(dbPassword, hashedUserPassword);
                    }
                    if (valid) ** GOTO lbl48
                    HopsworksJDBCRealm._logger.finest((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$isUserValid$0(java.lang.String ), ()Ljava/lang/String;)((String)user));
                }
                catch (Throwable var10_14) {
                    var9_11 = var10_14;
                    throw var10_14;
                }
                finally {
                    if (reader != null) {
                        if (var9_11 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable var10_13) {
                                var9_11.addSuppressed(var10_13);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            } else {
                HopsworksJDBCRealm._logger.finest((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$isUserValid$1(java.lang.String ), ()Ljava/lang/String;)((String)user));
            }
lbl48:
            // 3 sources

            this.close(connection, statement, resultSet);
        }
        catch (SQLException ex) {
            HopsworksJDBCRealm._logger.log(Level.SEVERE, "jdbcrealm.invaliduserreason", new String[]{user, ex.toString()});
            HopsworksJDBCRealm._logger.log(Level.FINE, "Cannot validate user", ex);
            this.close(connection, statement, resultSet);
        }
        catch (Exception ex) {
            HopsworksJDBCRealm._logger.log(Level.SEVERE, "jdbcrealm.invaliduser", user);
            HopsworksJDBCRealm._logger.log(Level.FINE, "Cannot validate user", ex);
            this.close(connection, statement, resultSet);
            {
                catch (Throwable var16_20) {
                    this.close(connection, statement, resultSet);
                    throw var16_20;
                }
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] hashPassword(char[] password) throws CharacterCodingException {
        String encoding;
        byte[] bytes = null;
        char[] result = null;
        String charSet = this.getProperty(PARAM_CHARSET);
        bytes = Utility.convertCharArrayToByteArray((char[])password, (String)charSet);
        if (this.md != null) {
            MessageDigest messageDigest = this.md;
            synchronized (messageDigest) {
                this.md.reset();
                bytes = this.md.digest(bytes);
            }
        }
        result = "hex".equalsIgnoreCase(encoding = this.getProperty(PARAM_ENCODING)) ? this.hexEncode(bytes) : (BASE64.equalsIgnoreCase(encoding) ? this.base64Encode(bytes).toCharArray() : Utility.convertByteArrayToCharArray((byte[])bytes, (String)charSet));
        return result;
    }

    private char[] hexEncode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            int low = b & 0xF;
            int high = (b & 0xF0) >> 4;
            sb.append(HEXADECIMAL[high]);
            sb.append(HEXADECIMAL[low]);
        }
        char[] result = new char[sb.length()];
        sb.getChars(0, sb.length(), result, 0);
        return result;
    }

    private String base64Encode(byte[] bytes) {
        return new String(Base64.getMimeEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findGroups(String user) {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.groupQuery);
            statement.setString(1, user);
            rs = statement.executeQuery();
            ArrayList<String> groups = new ArrayList<String>();
            while (rs.next()) {
                groups.add(rs.getString(1));
            }
            String[] groupArray = new String[groups.size()];
            String[] stringArray = groups.toArray(groupArray);
            this.close(connection, statement, rs);
            return stringArray;
        }
        catch (Exception ex) {
            try {
                _logger.log(Level.SEVERE, "jdbcrealm.grouperror", user);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Cannot load group", ex);
                }
                String[] stringArray = null;
                this.close(connection, statement, rs);
                return stringArray;
            }
            catch (Throwable throwable) {
                this.close(connection, statement, rs);
                throw throwable;
            }
        }
    }

    private void close(Connection conn, PreparedStatement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Connection getConnection() throws LoginException {
        String dsJndi = this.getProperty(PARAM_DATASOURCE_JNDI);
        String dbUser = this.getProperty(PARAM_DB_USER);
        String dbPassword = this.getProperty(PARAM_DB_PASSWORD);
        try {
            ConnectorRuntime connectorRuntime = (ConnectorRuntime)Globals.getStaticHabitat().getServiceHandle(this.connectorRuntimeDescriptor).getService();
            DataSource dataSource = (DataSource)connectorRuntime.lookupNonTxResource(dsJndi, false);
            Connection connection = dbUser != null && dbPassword != null ? dataSource.getConnection(dbUser, dbPassword) : dataSource.getConnection();
            return connection;
        }
        catch (Exception ex) {
            LoginException loginEx = new LoginException(sm.getString("jdbcrealm.cantconnect", (Object)dsJndi, (Object)dbUser));
            loginEx.initCause(ex);
            throw loginEx;
        }
    }

    private static /* synthetic */ String lambda$isUserValid$1(String user) {
        return "User '" + user + "' not found in the database!";
    }

    private static /* synthetic */ String lambda$isUserValid$0(String user) {
        return "User '" + user + "' password mismatch!";
    }
}

