/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.servicediscovery;

import io.hops.hopsworks.servicediscovery.tags.AirflowTags;
import io.hops.hopsworks.servicediscovery.tags.FlinkTags;
import io.hops.hopsworks.servicediscovery.tags.FlyingDuckTags;
import io.hops.hopsworks.servicediscovery.tags.GlassfishTags;
import io.hops.hopsworks.servicediscovery.tags.HiveTags;
import io.hops.hopsworks.servicediscovery.tags.KafkaTags;
import io.hops.hopsworks.servicediscovery.tags.LogstashTags;
import io.hops.hopsworks.servicediscovery.tags.MysqlTags;
import io.hops.hopsworks.servicediscovery.tags.NamenodeTags;
import io.hops.hopsworks.servicediscovery.tags.NoTags;
import io.hops.hopsworks.servicediscovery.tags.OpenSearchTags;
import io.hops.hopsworks.servicediscovery.tags.PrometheusTags;
import io.hops.hopsworks.servicediscovery.tags.ResourceManagerTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import io.hops.hopsworks.servicediscovery.tags.ZooKeeperTags;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class HopsworksService<T extends ServiceTags> {
    public static final HopsworksService<ResourceManagerTags> RESOURCE_MANAGER = HopsworksService.of((String)"resourcemanager", (ServiceTags[])ResourceManagerTags.values());
    public static final HopsworksService<NoTags> LIVY = HopsworksService.of("livy");
    public static final HopsworksService<ZooKeeperTags> ZOOKEEPER = HopsworksService.of((String)"zookeeper", (ServiceTags[])ZooKeeperTags.values());
    public static final HopsworksService<NoTags> SPARK_HISTORY_SERVER = HopsworksService.of("sparkhistoryserver");
    public static final HopsworksService<HiveTags> HIVE = HopsworksService.of((String)"hive", (ServiceTags[])HiveTags.values());
    public static final HopsworksService<NamenodeTags> NAMENODE = HopsworksService.of((String)"namenode", (ServiceTags[])NamenodeTags.values());
    public static final HopsworksService<LogstashTags> LOGSTASH = HopsworksService.of((String)"logstash", (ServiceTags[])LogstashTags.values());
    public static final HopsworksService<GlassfishTags> GLASSFISH = HopsworksService.of((String)"glassfish", (ServiceTags[])GlassfishTags.values());
    public static final HopsworksService<NoTags> DOCKER_REGISTRY = HopsworksService.of("registry");
    public static final HopsworksService<NoTags> CONSUL = HopsworksService.of("consul");
    public static final HopsworksService<MysqlTags> MYSQL = HopsworksService.of((String)"mysql", (ServiceTags[])MysqlTags.values());
    public static final HopsworksService<PrometheusTags> PROMETHEUS = HopsworksService.of((String)"prometheus", (ServiceTags[])PrometheusTags.values());
    public static final HopsworksService<NoTags> NODE_EXPORTER = HopsworksService.of("node_exporter");
    public static final HopsworksService<NoTags> GRAFANA = HopsworksService.of("grafana");
    public static final HopsworksService<AirflowTags> AIRFLOW = HopsworksService.of((String)"airflow", (ServiceTags[])AirflowTags.values());
    public static final HopsworksService<FlinkTags> FLINK = HopsworksService.of((String)"flink", (ServiceTags[])FlinkTags.values());
    public static final HopsworksService<FlyingDuckTags> FLYING_DUCK = HopsworksService.of((String)"flyingduck", (ServiceTags[])FlyingDuckTags.values());
    public static final HopsworksService<OpenSearchTags> OPENSEARCH = HopsworksService.of((String)"elastic", (ServiceTags[])OpenSearchTags.values());
    public static final HopsworksService<KafkaTags> KAFKA = HopsworksService.of((String)"kafka", (ServiceTags[])KafkaTags.values());
    private final String name;
    private final T[] tags;
    private final Set<String> domains;

    private HopsworksService(String name, T[] tags) {
        this.name = name;
        this.tags = tags;
        this.domains = new HashSet<String>();
        this.domains.add(this.getName());
        if (tags != null) {
            Arrays.stream(tags).forEach(s -> this.domains.add(String.format("%s.%s", s.getValue(), name)));
        }
    }

    public static <T extends ServiceTags> HopsworksService<T> of(String name) {
        return new HopsworksService(name, null);
    }

    public static <T extends ServiceTags> HopsworksService<T> of(String name, T[] tags) {
        return new HopsworksService(name, tags);
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithTag(T tag) {
        if (tag.getValue().isEmpty()) {
            return this.name;
        }
        return tag.getValue() + "." + this.name;
    }

    public Set<String> domains() {
        return this.domains;
    }
}

