/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.vectordb;

import io.hops.hopsworks.vectordb.OpensearchVectorDatabase;
import io.hops.hopsworks.vectordb.VectorDatabase;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.ssl.SSLContexts;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestHighLevelClient;

public class VectorDatabaseFactory {
    public static VectorDatabase getOpensearchDatabase(String host, String user, String password, String certPath, String trustStorePassword) throws IOException {
        SSLContext sslCtx = null;
        Path trustStore = Paths.get(certPath, new String[0]);
        char[] trustStorePw = null;
        if (trustStorePassword != null) {
            trustStorePw = trustStorePassword.toCharArray();
        }
        try {
            sslCtx = SSLContexts.custom().loadTrustMaterial(trustStore.toFile(), trustStorePw).build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IOException("Failed to load ssl context.");
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        SSLContext finalSslCtx = sslCtx;
        BasicCredentialsProvider finalCredentialsProvider = credentialsProvider;
        RestHighLevelClient client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)host)}).setHttpClientConfigCallback(arg_0 -> VectorDatabaseFactory.lambda$getOpensearchDatabase$0(finalSslCtx, (CredentialsProvider)finalCredentialsProvider, arg_0)));
        return new OpensearchVectorDatabase(client);
    }

    public static VectorDatabase getOpensearchDatabase(RestHighLevelClient client) {
        return new OpensearchVectorDatabase(client);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getOpensearchDatabase$0(SSLContext finalSslCtx, CredentialsProvider finalCredentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(5).build());
        return httpAsyncClientBuilder.setSSLContext(finalSslCtx).setDefaultCredentialsProvider(finalCredentialsProvider).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }
}

