/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.vectordb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.hops.hopsworks.vectordb.Field;
import io.hops.hopsworks.vectordb.Index;
import io.hops.hopsworks.vectordb.VectorDatabase;
import io.hops.hopsworks.vectordb.VectorDatabaseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Request;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetIndexResponse;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.rest.RestStatus;

public class OpensearchVectorDatabase
implements VectorDatabase {
    private RestHighLevelClient client = null;
    private ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger LOGGER = Logger.getLogger(OpensearchVectorDatabase.class.getName());

    public OpensearchVectorDatabase(RestHighLevelClient client) {
        this.client = client;
    }

    @Override
    public void createIndex(Index index, String mapping, Boolean skipIfExist) throws VectorDatabaseException {
        try {
            CreateIndexResponse response;
            if (skipIfExist.booleanValue()) {
                Request request = new Request("HEAD", "/" + index.getName());
                response = this.client.getLowLevelClient().performRequest(request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    return;
                }
            }
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(index.getName());
            createIndexRequest.source(mapping, XContentType.JSON);
            response = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
            if (!response.isAcknowledged()) {
                throw new VectorDatabaseException("Failed to create opensearch index: " + index.getName());
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to create opensearch index: " + index.getName() + "Err: " + e);
        }
    }

    @Override
    public Set<Index> getAllIndices() throws VectorDatabaseException {
        try {
            GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{"*"});
            GetIndexResponse getIndexResponse = this.client.indices().get(getIndexRequest, RequestOptions.DEFAULT);
            return getIndexResponse.getMappings().keySet().stream().map(Index::new).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to fetch opensearch indices. Err: " + e);
        }
    }

    @Override
    public void deleteIndex(Index index) throws VectorDatabaseException {
        try {
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(index.getName());
            AcknowledgedResponse response = this.client.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT);
            if (!response.isAcknowledged()) {
                throw new VectorDatabaseException("Failed to delete opensearch index: " + index.getName());
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to delete opensearch index: " + index.getName() + "Err: " + e);
        }
    }

    @Override
    public void addFields(Index index, String mapping) throws VectorDatabaseException {
        PutMappingRequest request = new PutMappingRequest(new String[]{index.getName()});
        request.source(mapping, XContentType.JSON);
        try {
            AcknowledgedResponse response = this.client.indices().putMapping(request, RequestOptions.DEFAULT);
            if (!response.isAcknowledged()) {
                throw new VectorDatabaseException("Failed to add fields to opensearch index: " + index.getName());
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to add fields to opensearch index: " + index.getName() + "Err: " + e);
        }
    }

    @Override
    public List<Field> getSchema(Index index) throws VectorDatabaseException {
        GetIndexRequest request = new GetIndexRequest(new String[]{index.getName()});
        try {
            GetIndexResponse response = this.client.indices().get(request, RequestOptions.DEFAULT);
            Object mapping = ((MappingMetadata)response.getMappings().get(index.getName())).getSourceAsMap().getOrDefault("properties", null);
            if (mapping != null) {
                return ((Map)mapping).entrySet().stream().map(entry -> new Field((String)entry.getKey(), entry.getValue())).collect(Collectors.toList());
            }
            return Lists.newArrayList();
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to get schema from opensearch index: " + index.getName() + "Err: " + e);
        }
    }

    @Override
    public void write(Index index, String data, String docId) throws VectorDatabaseException {
        try {
            IndexRequest indexRequest = this.makeIndexRequest(index.getName(), data, docId);
            IndexResponse response = this.client.index(indexRequest, RequestOptions.DEFAULT);
            if (!response.status().equals((Object)RestStatus.CREATED) && !response.status().equals((Object)RestStatus.OK)) {
                throw new VectorDatabaseException("Cannot index data. Status: " + response.status());
            }
        }
        catch (IOException | OpenSearchException e) {
            throw new VectorDatabaseException("Cannot index data. Err: " + e);
        }
    }

    private IndexRequest makeIndexRequest(String indexName, String data, String docId) {
        IndexRequest indexRequest = new IndexRequest(indexName).source(data, XContentType.JSON);
        if (docId != null) {
            indexRequest.id(docId);
        }
        return indexRequest;
    }

    @Override
    public void write(Index index, String data) throws VectorDatabaseException {
        this.write(index, data, null);
    }

    @Override
    public void batchWrite(Index index, List<String> data) throws VectorDatabaseException {
        BulkRequest bulkRequest = new BulkRequest();
        for (String doc : data) {
            bulkRequest.add(this.makeIndexRequest(index.getName(), doc, null));
        }
        this.bulkRequest(bulkRequest);
    }

    @Override
    public void batchWrite(Index index, Map<String, String> data) throws VectorDatabaseException {
        BulkRequest bulkRequest = new BulkRequest();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            bulkRequest.add(this.makeIndexRequest(index.getName(), entry.getValue(), entry.getKey()));
        }
        this.bulkRequest(bulkRequest);
    }

    private void bulkRequest(BulkRequest bulkRequest) throws VectorDatabaseException {
        try {
            BulkResponse response = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (response.status().getStatus() != 200) {
                throw new VectorDatabaseException(String.format("Cannot index data. Response status %d; Message: %s", response.status().getStatus(), response.buildFailureMessage()));
            }
            if (response.hasFailures()) {
                throw new VectorDatabaseException(String.format("Index data failed partially. Response status %d; Message: %s", response.status().getStatus(), response.buildFailureMessage()));
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Cannot index data. Err: " + e);
        }
    }

    @Override
    public void writeMap(Index index, Map<String, Object> data) throws VectorDatabaseException {
        this.writeMap(index, data, null);
    }

    @Override
    public void writeMap(Index index, Map<String, Object> data, String docId) throws VectorDatabaseException {
        try {
            this.write(index, this.objectMapper.writeValueAsString(data), docId);
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to index data because data cannot be written to String.");
        }
    }

    @Override
    public void batchWriteMap(Index index, List<Map<String, Object>> data) throws VectorDatabaseException {
        ArrayList batchData = Lists.newArrayList();
        try {
            for (Map<String, Object> map : data) {
                batchData.add(this.objectMapper.writeValueAsString(map));
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to index data because data cannot be written to String.");
        }
        this.batchWrite(index, batchData);
    }

    @Override
    public void batchWriteMap(Index index, Map<String, Map<String, Object>> data) throws VectorDatabaseException {
        HashMap batchData = Maps.newHashMap();
        try {
            for (Map.Entry<String, Map<String, Object>> entry : data.entrySet()) {
                batchData.put(entry.getKey(), this.objectMapper.writeValueAsString(entry.getValue()));
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to index data because data cannot be written to String.");
        }
        this.batchWrite(index, batchData);
    }

    @Override
    public void deleteByQuery(Index index, String query) throws VectorDatabaseException {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{index.getName()});
        deleteByQueryRequest.setQuery((QueryBuilder)new QueryStringQueryBuilder(query));
        try {
            BulkByScrollResponse response = this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            if (response.getBulkFailures().size() != 0) {
                throw new VectorDatabaseException("Drop index failed partially. Message: " + response.getBulkFailures().stream().map(f -> String.format("Index: %s , responseId: %s, status: %d, message: %s", f.getIndex(), f.getId(), f.getStatus().getStatus(), f.getMessage())).collect(Collectors.joining("\t")));
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to delete opensearch data.");
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
                this.client = null;
            }
            catch (IOException e) {
                throw new OpenSearchException("Error while shuting down client", new Object[0]);
            }
        }
    }
}

