/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.vectordb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.hops.hopsworks.vectordb.Field;
import io.hops.hopsworks.vectordb.Index;
import io.hops.hopsworks.vectordb.VectorDatabase;
import io.hops.hopsworks.vectordb.VectorDatabaseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.client.config.RequestConfig;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetIndexResponse;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.Strings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class OpensearchVectorDatabase
implements VectorDatabase {
    private RestHighLevelClient client = null;
    private ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger LOGGER = Logger.getLogger(OpensearchVectorDatabase.class.getName());
    private Integer requestTimeout = 60000;
    private Integer socketTimeout = 61000;
    private final Integer maxRetry = 3;
    private static final Map<String, String> dataTypeMap = ImmutableMap.builder().put((Object)"BOOLEAN", (Object)"byte").put((Object)"TINYINT", (Object)"byte").put((Object)"INT", (Object)"integer").put((Object)"SMALLINT", (Object)"short").put((Object)"BIGINT", (Object)"long").put((Object)"FLOAT", (Object)"float").put((Object)"DOUBLE", (Object)"double").put((Object)"TIMESTAMP", (Object)"date").put((Object)"DATE", (Object)"date").put((Object)"STRING", (Object)"text").put((Object)"ARRAY", (Object)"binary").put((Object)"STRUCT", (Object)"binary").put((Object)"BINARY", (Object)"binary").put((Object)"MAP", (Object)"binary").build();

    public static String getDataType(String offlineType) {
        if (Strings.isNullOrEmpty((String)offlineType)) {
            return null;
        }
        offlineType = offlineType.split("<")[0];
        return dataTypeMap.get(offlineType.toUpperCase());
    }

    public OpensearchVectorDatabase() {
    }

    public OpensearchVectorDatabase(RestHighLevelClient client) {
        this.client = client;
    }

    public OpensearchVectorDatabase(RestHighLevelClient client, Integer requestTimeout) {
        this.client = client;
        this.requestTimeout = requestTimeout;
        this.socketTimeout = requestTimeout + 1000;
    }

    public void init(RestHighLevelClient client) {
        this.client = client;
    }

    protected RestHighLevelClient getClient() throws VectorDatabaseException {
        return this.client;
    }

    @Override
    public void createIndex(Index index, String mapping, Boolean skipIfExist) throws VectorDatabaseException {
        if (skipIfExist.booleanValue() && this.getIndex(index.getName()).isPresent()) {
            return;
        }
        this.retry(() -> {
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(index.getName());
            createIndexRequest.setTimeout(new TimeValue((long)this.requestTimeout.intValue()));
            createIndexRequest.setMasterTimeout(new TimeValue((long)this.requestTimeout.intValue()));
            createIndexRequest.source(mapping, XContentType.JSON);
            CreateIndexResponse response = this.getClient().indices().create(createIndexRequest, this.getRequestOptions());
            if (response.isAcknowledged()) {
                return new OperationResult<Object>(true, null);
            }
            return new OperationResult<Object>(false, null);
        }, "create index", Sets.newHashSet((Object[])new RestStatus[]{RestStatus.OK, RestStatus.CREATED}));
    }

    @Override
    public Optional<Index> getIndex(String name) throws VectorDatabaseException {
        return this.retry(() -> {
            GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{name});
            GetIndexResponse getIndexResponse = this.getClient().indices().get(getIndexRequest, RequestOptions.DEFAULT);
            Optional<Index> result = getIndexResponse.getMappings().keySet().stream().map(Index::new).findFirst();
            return result.map(index -> new OperationResult<Index>(true, (Index)index)).orElseGet(() -> new OperationResult<Object>(false, null));
        }, "get index", Sets.newHashSet((Object[])new RestStatus[]{RestStatus.OK, RestStatus.NOT_FOUND}));
    }

    @Override
    public Set<Index> getAllIndices() throws VectorDatabaseException {
        Optional<Set> result = this.retry(() -> {
            GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{"*"});
            GetIndexResponse getIndexResponse = this.getClient().indices().get(getIndexRequest, RequestOptions.DEFAULT);
            return new OperationResult(true, getIndexResponse.getMappings().keySet().stream().map(Index::new).collect(Collectors.toSet()));
        }, "get all indices", Sets.newHashSet((Object[])new RestStatus[]{RestStatus.OK}));
        return result.orElseGet(Sets::newHashSet);
    }

    @Override
    public void deleteIndex(Index index) throws VectorDatabaseException {
        this.retry(() -> {
            DeleteIndexRequest deleteIndexRequest = (DeleteIndexRequest)((DeleteIndexRequest)new DeleteIndexRequest(index.getName()).timeout(new TimeValue((long)this.requestTimeout.intValue()))).masterNodeTimeout(new TimeValue((long)this.requestTimeout.intValue()));
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout.intValue()).build();
            RequestOptions options = RequestOptions.DEFAULT.toBuilder().setRequestConfig(requestConfig).build();
            AcknowledgedResponse response = this.getClient().indices().delete(deleteIndexRequest, options);
            if (response.isAcknowledged()) {
                return new OperationResult<Object>(true, null);
            }
            return new OperationResult<Object>(false, null);
        }, "delete index", Sets.newHashSet((Object[])new RestStatus[]{RestStatus.OK, RestStatus.NOT_FOUND}));
    }

    @Override
    public void addFields(Index index, String mapping) throws VectorDatabaseException {
        PutMappingRequest request = new PutMappingRequest(new String[]{index.getName()});
        request.source(mapping, XContentType.JSON);
        try {
            AcknowledgedResponse response = this.getClient().indices().putMapping(request, RequestOptions.DEFAULT);
            if (!response.isAcknowledged()) {
                throw new VectorDatabaseException("Failed to add fields to opensearch index: " + index.getName());
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to add fields to opensearch index: " + index.getName() + "Err: " + e);
        }
    }

    @Override
    public List<Field> getSchema(Index index) throws VectorDatabaseException {
        GetIndexRequest request = new GetIndexRequest(new String[]{index.getName()});
        try {
            GetIndexResponse response = this.getClient().indices().get(request, RequestOptions.DEFAULT);
            Object mapping = ((MappingMetadata)response.getMappings().get(index.getName())).getSourceAsMap().getOrDefault("properties", null);
            if (mapping != null) {
                return ((Map)mapping).entrySet().stream().map(entry -> new Field((String)entry.getKey(), entry.getValue())).collect(Collectors.toList());
            }
            return Lists.newArrayList();
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to get schema from opensearch index: " + index.getName() + "Err: " + e);
        }
    }

    @Override
    public void write(Index index, String data, String docId) throws VectorDatabaseException {
        try {
            IndexRequest indexRequest = this.makeIndexRequest(index.getName(), data, docId);
            IndexResponse response = this.getClient().index(indexRequest, RequestOptions.DEFAULT);
            if (!response.status().equals((Object)RestStatus.CREATED) && !response.status().equals((Object)RestStatus.OK)) {
                throw new VectorDatabaseException("Cannot index data. Status: " + response.status());
            }
        }
        catch (IOException | OpenSearchException e) {
            throw new VectorDatabaseException("Cannot index data. Err: " + (Exception)e);
        }
    }

    private IndexRequest makeIndexRequest(String indexName, String data, String docId) {
        IndexRequest indexRequest = new IndexRequest(indexName).source(data, XContentType.JSON);
        if (docId != null) {
            indexRequest.id(docId);
        }
        return indexRequest;
    }

    @Override
    public void write(Index index, String data) throws VectorDatabaseException {
        this.write(index, data, null);
    }

    @Override
    public void batchWrite(Index index, List<String> data) throws VectorDatabaseException {
        BulkRequest bulkRequest = new BulkRequest();
        for (String doc : data) {
            bulkRequest.add(this.makeIndexRequest(index.getName(), doc, null));
        }
        this.bulkRequest(bulkRequest);
    }

    @Override
    public void batchWrite(Index index, Map<String, String> data) throws VectorDatabaseException {
        BulkRequest bulkRequest = new BulkRequest();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            bulkRequest.add(this.makeIndexRequest(index.getName(), entry.getValue(), entry.getKey()));
        }
        this.bulkRequest(bulkRequest);
    }

    @Override
    public List<Map<String, Object>> preview(Index index, Set<Field> fields, int n) throws VectorDatabaseException {
        ArrayList results = Lists.newArrayList();
        if (fields.size() == 0) {
            return results;
        }
        Optional<List> result = this.retry(() -> {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            for (Field field : fields) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)field.getName()));
            }
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.size(n);
            SearchRequest searchRequest = new SearchRequest(new String[]{index.getName()});
            searchRequest.source(sourceBuilder);
            SearchResponse searchResponse = this.getClient().search(searchRequest, RequestOptions.DEFAULT);
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                results.add(hit.getSourceAsMap());
            }
            return new OperationResult<List>(true, results);
        }, "preview", Sets.newHashSet((Object[])new RestStatus[]{RestStatus.OK}));
        return result.orElseGet(() -> results);
    }

    private void bulkRequest(BulkRequest bulkRequest) throws VectorDatabaseException {
        try {
            BulkResponse response = this.getClient().bulk(bulkRequest, RequestOptions.DEFAULT);
            if (response.hasFailures()) {
                String msg = String.format("Index data failed partially. Response status %d", response.status().getStatus());
                throw new VectorDatabaseException(msg);
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Cannot index data. Err: " + e);
        }
    }

    @Override
    public void writeMap(Index index, Map<String, Object> data) throws VectorDatabaseException {
        this.writeMap(index, data, null);
    }

    @Override
    public void writeMap(Index index, Map<String, Object> data, String docId) throws VectorDatabaseException {
        try {
            this.write(index, this.objectMapper.writeValueAsString(data), docId);
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to index data because data cannot be written to String.");
        }
    }

    @Override
    public void batchWriteMap(Index index, List<Map<String, Object>> data) throws VectorDatabaseException {
        ArrayList batchData = Lists.newArrayList();
        try {
            for (Map<String, Object> map : data) {
                batchData.add(this.objectMapper.writeValueAsString(map));
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to index data because data cannot be written to String.");
        }
        this.batchWrite(index, batchData);
    }

    @Override
    public void batchWriteMap(Index index, Map<String, Map<String, Object>> data) throws VectorDatabaseException {
        HashMap batchData = Maps.newHashMap();
        try {
            for (Map.Entry<String, Map<String, Object>> entry : data.entrySet()) {
                batchData.put(entry.getKey(), this.objectMapper.writeValueAsString(entry.getValue()));
            }
        }
        catch (IOException e) {
            throw new VectorDatabaseException("Failed to index data because data cannot be written to String.");
        }
        this.batchWrite(index, batchData);
    }

    @Override
    public void deleteByQuery(Index index, String query) throws VectorDatabaseException {
        this.retry(() -> {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{index.getName()});
            deleteByQueryRequest.setQuery((QueryBuilder)new QueryStringQueryBuilder(query));
            deleteByQueryRequest.setTimeout(new TimeValue((long)this.requestTimeout.intValue()));
            BulkByScrollResponse response = this.getClient().deleteByQuery(deleteByQueryRequest, this.getRequestOptions());
            if (response.getBulkFailures().isEmpty()) {
                return new OperationResult<Object>(true, null);
            }
            return new OperationResult<Object>(false, null);
        }, "delete by query", Sets.newHashSet((Object[])new RestStatus[]{RestStatus.OK}));
    }

    private long getDelayMillis(long delayMillis) {
        return Math.min(delayMillis, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> Optional<T> retry(OperationSupplier operation, String operationName, Set<RestStatus> expectedStatus) throws VectorDatabaseException {
        long delayMillis = 1000L;
        boolean retryStarted = false;
        try {
            for (int i = 0; i < this.maxRetry; ++i) {
                block18: {
                    OperationResult operationResult = operation.perform();
                    if (!operationResult.success.booleanValue()) break block18;
                    Optional optional = Optional.ofNullable(operationResult.result);
                    return optional;
                }
                try {
                    if (i >= this.maxRetry - 1 || !this.shouldRetry().booleanValue()) throw new VectorDatabaseException(String.format("Operation %s failed after retries.", operationName));
                    if (!retryStarted) {
                        this.startRetry();
                        retryStarted = true;
                    }
                    Thread.sleep(this.getDelayMillis(delayMillis));
                    delayMillis *= 2L;
                    continue;
                }
                catch (IOException e) {
                    throw new VectorDatabaseException(String.format("Failed to %s index: %s", operationName, e.getMessage()));
                }
                catch (OpenSearchStatusException e) {
                    if (expectedStatus.contains(e.status())) {
                        Optional optional = Optional.empty();
                        if (!retryStarted) return optional;
                        this.doneRetry();
                        return optional;
                    }
                    try {
                        if (!e.getDetailedMessage().contains("process_cluster_event_timeout_exception")) throw new VectorDatabaseException(String.format("Failed to %s index: %s", operationName, e.getDetailedMessage()));
                        LOGGER.log(Level.INFO, String.format("Failed to %s: %s", operationName, e.getDetailedMessage()));
                        if (i >= this.maxRetry - 1 || !this.shouldRetry().booleanValue()) throw new VectorDatabaseException(String.format("Operation %s failed after retries.", operationName));
                        if (!retryStarted) {
                            this.startRetry();
                            retryStarted = true;
                        }
                        Thread.sleep(this.getDelayMillis(delayMillis));
                        delayMillis *= 2L;
                        continue;
                    }
                    catch (InterruptedException e2) {
                        try {
                            LOGGER.log(Level.INFO, String.format("Retry %s interrupted.", operationName));
                            throw new VectorDatabaseException(String.format("Operation %s failed after retries.", operationName));
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            throw new VectorDatabaseException(String.format("Operation %s failed after retries.", operationName));
                        }
                    }
                }
            }
        }
        finally {
            if (retryStarted) {
                this.doneRetry();
            }
        }
    }

    protected Boolean shouldRetry() {
        return true;
    }

    protected void startRetry() {
    }

    protected void doneRetry() {
    }

    private RequestOptions getRequestOptions() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout.intValue()).build();
        return RequestOptions.DEFAULT.toBuilder().setRequestConfig(requestConfig).build();
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
                this.client = null;
            }
            catch (IOException e) {
                throw new OpenSearchException("Error while shuting down client", new Object[0]);
            }
        }
    }

    @FunctionalInterface
    protected static interface OperationSupplier {
        public OperationResult perform() throws IOException, OpenSearchStatusException, VectorDatabaseException;
    }

    protected static class OperationResult<T> {
        private final Boolean success;
        private final T result;

        @Generated
        public OperationResult(Boolean success, T result) {
            this.success = success;
            this.result = result;
        }
    }
}

