/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricStreamResponse extends CloudWatchResponse implements
        ToCopyableBuilder<GetMetricStreamResponse.Builder, GetMetricStreamResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetMetricStreamResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetMetricStreamResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<MetricStreamFilter>> INCLUDE_FILTERS_FIELD = SdkField
            .<List<MetricStreamFilter>> builder(MarshallingType.LIST)
            .memberName("IncludeFilters")
            .getter(getter(GetMetricStreamResponse::includeFilters))
            .setter(setter(Builder::includeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricStreamFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricStreamFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricStreamFilter>> EXCLUDE_FILTERS_FIELD = SdkField
            .<List<MetricStreamFilter>> builder(MarshallingType.LIST)
            .memberName("ExcludeFilters")
            .getter(getter(GetMetricStreamResponse::excludeFilters))
            .setter(setter(Builder::excludeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricStreamFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricStreamFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FIREHOSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirehoseArn").getter(getter(GetMetricStreamResponse::firehoseArn)).setter(setter(Builder::firehoseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(GetMetricStreamResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetMetricStreamResponse::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(GetMetricStreamResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateDate").getter(getter(GetMetricStreamResponse::lastUpdateDate))
            .setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDate").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(GetMetricStreamResponse::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()).build();

    private static final SdkField<List<MetricStreamStatisticsConfiguration>> STATISTICS_CONFIGURATIONS_FIELD = SdkField
            .<List<MetricStreamStatisticsConfiguration>> builder(MarshallingType.LIST)
            .memberName("StatisticsConfigurations")
            .getter(getter(GetMetricStreamResponse::statisticsConfigurations))
            .setter(setter(Builder::statisticsConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticsConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricStreamStatisticsConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricStreamStatisticsConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_LINKED_ACCOUNTS_METRICS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeLinkedAccountsMetrics")
            .getter(getter(GetMetricStreamResponse::includeLinkedAccountsMetrics))
            .setter(setter(Builder::includeLinkedAccountsMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeLinkedAccountsMetrics")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            INCLUDE_FILTERS_FIELD, EXCLUDE_FILTERS_FIELD, FIREHOSE_ARN_FIELD, ROLE_ARN_FIELD, STATE_FIELD, CREATION_DATE_FIELD,
            LAST_UPDATE_DATE_FIELD, OUTPUT_FORMAT_FIELD, STATISTICS_CONFIGURATIONS_FIELD, INCLUDE_LINKED_ACCOUNTS_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final List<MetricStreamFilter> includeFilters;

    private final List<MetricStreamFilter> excludeFilters;

    private final String firehoseArn;

    private final String roleArn;

    private final String state;

    private final Instant creationDate;

    private final Instant lastUpdateDate;

    private final String outputFormat;

    private final List<MetricStreamStatisticsConfiguration> statisticsConfigurations;

    private final Boolean includeLinkedAccountsMetrics;

    private GetMetricStreamResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.includeFilters = builder.includeFilters;
        this.excludeFilters = builder.excludeFilters;
        this.firehoseArn = builder.firehoseArn;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.outputFormat = builder.outputFormat;
        this.statisticsConfigurations = builder.statisticsConfigurations;
        this.includeLinkedAccountsMetrics = builder.includeLinkedAccountsMetrics;
    }

    /**
     * <p>
     * The ARN of the metric stream.
     * </p>
     * 
     * @return The ARN of the metric stream.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the metric stream.
     * </p>
     * 
     * @return The name of the metric stream.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludeFilters() {
        return includeFilters != null && !(includeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are
     * streamed by this metric stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeFilters} method.
     * </p>
     * 
     * @return If this array of metric namespaces is present, then these namespaces are the only metric namespaces that
     *         are streamed by this metric stream.
     */
    public final List<MetricStreamFilter> includeFilters() {
        return includeFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeFilters() {
        return excludeFilters != null && !(excludeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are not
     * streamed by this metric stream. In this case, all other metric namespaces in the account are streamed by this
     * metric stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeFilters} method.
     * </p>
     * 
     * @return If this array of metric namespaces is present, then these namespaces are the only metric namespaces that
     *         are not streamed by this metric stream. In this case, all other metric namespaces in the account are
     *         streamed by this metric stream.
     */
    public final List<MetricStreamFilter> excludeFilters() {
        return excludeFilters;
    }

    /**
     * <p>
     * The ARN of the Amazon Kinesis Data Firehose delivery stream that is used by this metric stream.
     * </p>
     * 
     * @return The ARN of the Amazon Kinesis Data Firehose delivery stream that is used by this metric stream.
     */
    public final String firehoseArn() {
        return firehoseArn;
    }

    /**
     * <p>
     * The ARN of the IAM role that is used by this metric stream.
     * </p>
     * 
     * @return The ARN of the IAM role that is used by this metric stream.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The state of the metric stream. The possible values are <code>running</code> and <code>stopped</code>.
     * </p>
     * 
     * @return The state of the metric stream. The possible values are <code>running</code> and <code>stopped</code>.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The date that the metric stream was created.
     * </p>
     * 
     * @return The date that the metric stream was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date of the most recent update to the metric stream's configuration.
     * </p>
     * 
     * @return The date of the most recent update to the metric stream's configuration.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    /**
     * <p>
     * The output format for the stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>, and
     * <code>opentelemetry0.7</code>. For more information about metric stream output formats, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
     * >Metric streams output formats</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link MetricStreamOutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The output format for the stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>, and
     *         <code>opentelemetry0.7</code>. For more information about metric stream output formats, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
     *         >Metric streams output formats</a>.
     * @see MetricStreamOutputFormat
     */
    public final MetricStreamOutputFormat outputFormat() {
        return MetricStreamOutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * The output format for the stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>, and
     * <code>opentelemetry0.7</code>. For more information about metric stream output formats, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
     * >Metric streams output formats</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link MetricStreamOutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The output format for the stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>, and
     *         <code>opentelemetry0.7</code>. For more information about metric stream output formats, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
     *         >Metric streams output formats</a>.
     * @see MetricStreamOutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatisticsConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatisticsConfigurations() {
        return statisticsConfigurations != null && !(statisticsConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each entry in this array displays information about one or more metrics that include additional statistics in the
     * metric stream. For more information about the additional statistics, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">
     * CloudWatch statistics definitions</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatisticsConfigurations} method.
     * </p>
     * 
     * @return Each entry in this array displays information about one or more metrics that include additional
     *         statistics in the metric stream. For more information about the additional statistics, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">
     *         CloudWatch statistics definitions</a>.
     */
    public final List<MetricStreamStatisticsConfiguration> statisticsConfigurations() {
        return statisticsConfigurations;
    }

    /**
     * <p>
     * If this is <code>true</code> and this metric stream is in a monitoring account, then the stream includes metrics
     * from source accounts that the monitoring account is linked to.
     * </p>
     * 
     * @return If this is <code>true</code> and this metric stream is in a monitoring account, then the stream includes
     *         metrics from source accounts that the monitoring account is linked to.
     */
    public final Boolean includeLinkedAccountsMetrics() {
        return includeLinkedAccountsMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeFilters() ? includeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeFilters() ? excludeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(firehoseArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatisticsConfigurations() ? statisticsConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeLinkedAccountsMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStreamResponse)) {
            return false;
        }
        GetMetricStreamResponse other = (GetMetricStreamResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && hasIncludeFilters() == other.hasIncludeFilters() && Objects.equals(includeFilters(), other.includeFilters())
                && hasExcludeFilters() == other.hasExcludeFilters() && Objects.equals(excludeFilters(), other.excludeFilters())
                && Objects.equals(firehoseArn(), other.firehoseArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(state(), other.state()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastUpdateDate(), other.lastUpdateDate())
                && Objects.equals(outputFormatAsString(), other.outputFormatAsString())
                && hasStatisticsConfigurations() == other.hasStatisticsConfigurations()
                && Objects.equals(statisticsConfigurations(), other.statisticsConfigurations())
                && Objects.equals(includeLinkedAccountsMetrics(), other.includeLinkedAccountsMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricStreamResponse").add("Arn", arn()).add("Name", name())
                .add("IncludeFilters", hasIncludeFilters() ? includeFilters() : null)
                .add("ExcludeFilters", hasExcludeFilters() ? excludeFilters() : null).add("FirehoseArn", firehoseArn())
                .add("RoleArn", roleArn()).add("State", state()).add("CreationDate", creationDate())
                .add("LastUpdateDate", lastUpdateDate()).add("OutputFormat", outputFormatAsString())
                .add("StatisticsConfigurations", hasStatisticsConfigurations() ? statisticsConfigurations() : null)
                .add("IncludeLinkedAccountsMetrics", includeLinkedAccountsMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IncludeFilters":
            return Optional.ofNullable(clazz.cast(includeFilters()));
        case "ExcludeFilters":
            return Optional.ofNullable(clazz.cast(excludeFilters()));
        case "FirehoseArn":
            return Optional.ofNullable(clazz.cast(firehoseArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        case "StatisticsConfigurations":
            return Optional.ofNullable(clazz.cast(statisticsConfigurations()));
        case "IncludeLinkedAccountsMetrics":
            return Optional.ofNullable(clazz.cast(includeLinkedAccountsMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("IncludeFilters", INCLUDE_FILTERS_FIELD);
        map.put("ExcludeFilters", EXCLUDE_FILTERS_FIELD);
        map.put("FirehoseArn", FIREHOSE_ARN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastUpdateDate", LAST_UPDATE_DATE_FIELD);
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        map.put("StatisticsConfigurations", STATISTICS_CONFIGURATIONS_FIELD);
        map.put("IncludeLinkedAccountsMetrics", INCLUDE_LINKED_ACCOUNTS_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetricStreamResponse, T> g) {
        return obj -> g.apply((GetMetricStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricStreamResponse> {
        /**
         * <p>
         * The ARN of the metric stream.
         * </p>
         * 
         * @param arn
         *        The ARN of the metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the metric stream.
         * </p>
         * 
         * @param name
         *        The name of the metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are
         * streamed by this metric stream.
         * </p>
         * 
         * @param includeFilters
         *        If this array of metric namespaces is present, then these namespaces are the only metric namespaces
         *        that are streamed by this metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFilters(Collection<MetricStreamFilter> includeFilters);

        /**
         * <p>
         * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are
         * streamed by this metric stream.
         * </p>
         * 
         * @param includeFilters
         *        If this array of metric namespaces is present, then these namespaces are the only metric namespaces
         *        that are streamed by this metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFilters(MetricStreamFilter... includeFilters);

        /**
         * <p>
         * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are
         * streamed by this metric stream.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #includeFilters(List<MetricStreamFilter>)}.
         * 
         * @param includeFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includeFilters(java.util.Collection<MetricStreamFilter>)
         */
        Builder includeFilters(Consumer<MetricStreamFilter.Builder>... includeFilters);

        /**
         * <p>
         * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are
         * not streamed by this metric stream. In this case, all other metric namespaces in the account are streamed by
         * this metric stream.
         * </p>
         * 
         * @param excludeFilters
         *        If this array of metric namespaces is present, then these namespaces are the only metric namespaces
         *        that are not streamed by this metric stream. In this case, all other metric namespaces in the account
         *        are streamed by this metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeFilters(Collection<MetricStreamFilter> excludeFilters);

        /**
         * <p>
         * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are
         * not streamed by this metric stream. In this case, all other metric namespaces in the account are streamed by
         * this metric stream.
         * </p>
         * 
         * @param excludeFilters
         *        If this array of metric namespaces is present, then these namespaces are the only metric namespaces
         *        that are not streamed by this metric stream. In this case, all other metric namespaces in the account
         *        are streamed by this metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeFilters(MetricStreamFilter... excludeFilters);

        /**
         * <p>
         * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are
         * not streamed by this metric stream. In this case, all other metric namespaces in the account are streamed by
         * this metric stream.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #excludeFilters(List<MetricStreamFilter>)}.
         * 
         * @param excludeFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludeFilters(java.util.Collection<MetricStreamFilter>)
         */
        Builder excludeFilters(Consumer<MetricStreamFilter.Builder>... excludeFilters);

        /**
         * <p>
         * The ARN of the Amazon Kinesis Data Firehose delivery stream that is used by this metric stream.
         * </p>
         * 
         * @param firehoseArn
         *        The ARN of the Amazon Kinesis Data Firehose delivery stream that is used by this metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehoseArn(String firehoseArn);

        /**
         * <p>
         * The ARN of the IAM role that is used by this metric stream.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that is used by this metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The state of the metric stream. The possible values are <code>running</code> and <code>stopped</code>.
         * </p>
         * 
         * @param state
         *        The state of the metric stream. The possible values are <code>running</code> and <code>stopped</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The date that the metric stream was created.
         * </p>
         * 
         * @param creationDate
         *        The date that the metric stream was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date of the most recent update to the metric stream's configuration.
         * </p>
         * 
         * @param lastUpdateDate
         *        The date of the most recent update to the metric stream's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);

        /**
         * <p>
         * The output format for the stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>, and
         * <code>opentelemetry0.7</code>. For more information about metric stream output formats, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
         * >Metric streams output formats</a>.
         * </p>
         * 
         * @param outputFormat
         *        The output format for the stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>,
         *        and <code>opentelemetry0.7</code>. For more information about metric stream output formats, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
         *        >Metric streams output formats</a>.
         * @see MetricStreamOutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStreamOutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * The output format for the stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>, and
         * <code>opentelemetry0.7</code>. For more information about metric stream output formats, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
         * >Metric streams output formats</a>.
         * </p>
         * 
         * @param outputFormat
         *        The output format for the stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>,
         *        and <code>opentelemetry0.7</code>. For more information about metric stream output formats, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
         *        >Metric streams output formats</a>.
         * @see MetricStreamOutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStreamOutputFormat
         */
        Builder outputFormat(MetricStreamOutputFormat outputFormat);

        /**
         * <p>
         * Each entry in this array displays information about one or more metrics that include additional statistics in
         * the metric stream. For more information about the additional statistics, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">
         * CloudWatch statistics definitions</a>.
         * </p>
         * 
         * @param statisticsConfigurations
         *        Each entry in this array displays information about one or more metrics that include additional
         *        statistics in the metric stream. For more information about the additional statistics, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">
         *        CloudWatch statistics definitions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsConfigurations(Collection<MetricStreamStatisticsConfiguration> statisticsConfigurations);

        /**
         * <p>
         * Each entry in this array displays information about one or more metrics that include additional statistics in
         * the metric stream. For more information about the additional statistics, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">
         * CloudWatch statistics definitions</a>.
         * </p>
         * 
         * @param statisticsConfigurations
         *        Each entry in this array displays information about one or more metrics that include additional
         *        statistics in the metric stream. For more information about the additional statistics, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">
         *        CloudWatch statistics definitions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsConfigurations(MetricStreamStatisticsConfiguration... statisticsConfigurations);

        /**
         * <p>
         * Each entry in this array displays information about one or more metrics that include additional statistics in
         * the metric stream. For more information about the additional statistics, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">
         * CloudWatch statistics definitions</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #statisticsConfigurations(List<MetricStreamStatisticsConfiguration>)}.
         * 
         * @param statisticsConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statisticsConfigurations(java.util.Collection<MetricStreamStatisticsConfiguration>)
         */
        Builder statisticsConfigurations(Consumer<MetricStreamStatisticsConfiguration.Builder>... statisticsConfigurations);

        /**
         * <p>
         * If this is <code>true</code> and this metric stream is in a monitoring account, then the stream includes
         * metrics from source accounts that the monitoring account is linked to.
         * </p>
         * 
         * @param includeLinkedAccountsMetrics
         *        If this is <code>true</code> and this metric stream is in a monitoring account, then the stream
         *        includes metrics from source accounts that the monitoring account is linked to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeLinkedAccountsMetrics(Boolean includeLinkedAccountsMetrics);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private List<MetricStreamFilter> includeFilters = DefaultSdkAutoConstructList.getInstance();

        private List<MetricStreamFilter> excludeFilters = DefaultSdkAutoConstructList.getInstance();

        private String firehoseArn;

        private String roleArn;

        private String state;

        private Instant creationDate;

        private Instant lastUpdateDate;

        private String outputFormat;

        private List<MetricStreamStatisticsConfiguration> statisticsConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeLinkedAccountsMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStreamResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            includeFilters(model.includeFilters);
            excludeFilters(model.excludeFilters);
            firehoseArn(model.firehoseArn);
            roleArn(model.roleArn);
            state(model.state);
            creationDate(model.creationDate);
            lastUpdateDate(model.lastUpdateDate);
            outputFormat(model.outputFormat);
            statisticsConfigurations(model.statisticsConfigurations);
            includeLinkedAccountsMetrics(model.includeLinkedAccountsMetrics);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<MetricStreamFilter.Builder> getIncludeFilters() {
            List<MetricStreamFilter.Builder> result = MetricStreamFiltersCopier.copyToBuilder(this.includeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludeFilters(Collection<MetricStreamFilter.BuilderImpl> includeFilters) {
            this.includeFilters = MetricStreamFiltersCopier.copyFromBuilder(includeFilters);
        }

        @Override
        public final Builder includeFilters(Collection<MetricStreamFilter> includeFilters) {
            this.includeFilters = MetricStreamFiltersCopier.copy(includeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFilters(MetricStreamFilter... includeFilters) {
            includeFilters(Arrays.asList(includeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFilters(Consumer<MetricStreamFilter.Builder>... includeFilters) {
            includeFilters(Stream.of(includeFilters).map(c -> MetricStreamFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MetricStreamFilter.Builder> getExcludeFilters() {
            List<MetricStreamFilter.Builder> result = MetricStreamFiltersCopier.copyToBuilder(this.excludeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeFilters(Collection<MetricStreamFilter.BuilderImpl> excludeFilters) {
            this.excludeFilters = MetricStreamFiltersCopier.copyFromBuilder(excludeFilters);
        }

        @Override
        public final Builder excludeFilters(Collection<MetricStreamFilter> excludeFilters) {
            this.excludeFilters = MetricStreamFiltersCopier.copy(excludeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFilters(MetricStreamFilter... excludeFilters) {
            excludeFilters(Arrays.asList(excludeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFilters(Consumer<MetricStreamFilter.Builder>... excludeFilters) {
            excludeFilters(Stream.of(excludeFilters).map(c -> MetricStreamFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFirehoseArn() {
            return firehoseArn;
        }

        public final void setFirehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
        }

        @Override
        public final Builder firehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(MetricStreamOutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final List<MetricStreamStatisticsConfiguration.Builder> getStatisticsConfigurations() {
            List<MetricStreamStatisticsConfiguration.Builder> result = MetricStreamStatisticsConfigurationsCopier
                    .copyToBuilder(this.statisticsConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatisticsConfigurations(
                Collection<MetricStreamStatisticsConfiguration.BuilderImpl> statisticsConfigurations) {
            this.statisticsConfigurations = MetricStreamStatisticsConfigurationsCopier.copyFromBuilder(statisticsConfigurations);
        }

        @Override
        public final Builder statisticsConfigurations(Collection<MetricStreamStatisticsConfiguration> statisticsConfigurations) {
            this.statisticsConfigurations = MetricStreamStatisticsConfigurationsCopier.copy(statisticsConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsConfigurations(MetricStreamStatisticsConfiguration... statisticsConfigurations) {
            statisticsConfigurations(Arrays.asList(statisticsConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsConfigurations(
                Consumer<MetricStreamStatisticsConfiguration.Builder>... statisticsConfigurations) {
            statisticsConfigurations(Stream.of(statisticsConfigurations)
                    .map(c -> MetricStreamStatisticsConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIncludeLinkedAccountsMetrics() {
            return includeLinkedAccountsMetrics;
        }

        public final void setIncludeLinkedAccountsMetrics(Boolean includeLinkedAccountsMetrics) {
            this.includeLinkedAccountsMetrics = includeLinkedAccountsMetrics;
        }

        @Override
        public final Builder includeLinkedAccountsMetrics(Boolean includeLinkedAccountsMetrics) {
            this.includeLinkedAccountsMetrics = includeLinkedAccountsMetrics;
            return this;
        }

        @Override
        public GetMetricStreamResponse build() {
            return new GetMetricStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
